
'use client';

import { SidebarProvider } from '@/components/ui/sidebar';
import { DashboardLayout } from '@/components/dashboard-layout';
import type { BookingResult, Parcel } from '@/lib/types';
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from '@/components/ui/card';
import { Input } from '@/components/ui/input';
import { Button } from '@/components/ui/button';
import { Search, Package, Warehouse, Truck, CheckCircle, Clock } from 'lucide-react';
import { useState } from 'react';
import { mockParcels } from '@/lib/data';
import { Badge } from '@/components/ui/badge';
import { format } from 'date-fns';

const journey = [
    { status: 'Booked', location: 'Multan', date: '2024-07-24 10:00 AM', icon: Package },
    { status: 'Received at Branch', location: 'Multan', date: '2024-07-24 11:30 AM', icon: Warehouse },
    { status: 'Dispatched to Hub', location: 'Multan', date: '2024-07-24 03:00 PM', icon: Truck },
    { status: 'Received at Hub', location: 'Lahore', date: '2024-07-25 09:00 AM', icon: Warehouse },
    { status: 'Out for Delivery', location: 'Lahore', date: '2024-07-25 10:00 AM', icon: Truck },
    { status: 'Delivered', location: 'Lahore', date: '2024-07-25 01:15 PM', icon: CheckCircle },
];


export default function AdminBranchTrackingPage() {
  
  const handleBookingComplete = (result: BookingResult) => {};
  const [parcelId, setParcelId] = useState('');
  const [trackedParcel, setTrackedParcel] = useState<Parcel | null>(null);

  const handleSearch = () => {
    const parcel = mockParcels.find(p => p.id.toLowerCase() === parcelId.toLowerCase());
    setTrackedParcel(parcel || null);
  }

  return (
    <SidebarProvider>
      <DashboardLayout onBookingComplete={handleBookingComplete} userRole="branch-operator">
        <div className="flex flex-col gap-8">
            <Card>
                <CardHeader>
                    <CardTitle>Shipment Tracking</CardTitle>
                    <CardDescription>
                        Enter a Parcel ID to view its detailed journey log.
                    </CardDescription>
                </CardHeader>
                <CardContent>
                    <div className="flex items-center gap-2 max-w-lg mx-auto">
                        <Input 
                            placeholder="Enter Parcel ID..." 
                            value={parcelId}
                            onChange={(e) => setParcelId(e.target.value)}
                        />
                        <Button onClick={handleSearch}>
                            <Search className="mr-2 h-4 w-4" /> Track
                        </Button>
                    </div>
                </CardContent>
            </Card>

            {trackedParcel && (
                <Card>
                    <CardHeader>
                        <div className="flex justify-between items-start">
                             <div>
                                <CardTitle>Tracking Details for {trackedParcel.id}</CardTitle>
                                <CardDescription>Recipient: {trackedParcel.recipientName}, {trackedParcel.city}</CardDescription>
                            </div>
                            <Badge className="text-base">{trackedParcel.status}</Badge>
                        </div>
                    </CardHeader>
                    <CardContent>
                        <div className="relative pl-6">
                            {/* Dotted line */}
                            <div className="absolute left-9 top-0 h-full w-0.5 border-l-2 border-dashed border-primary/50" />
                            
                            {journey.map((entry, index) => (
                                <div key={index} className="relative mb-8 flex items-start gap-6">
                                    <div className="absolute left-9 top-1/2 -translate-x-1/2 -translate-y-1/2 z-10">
                                         <div className="flex h-8 w-8 items-center justify-center rounded-full bg-primary text-primary-foreground">
                                            <entry.icon className="h-5 w-5" />
                                        </div>
                                    </div>
                                    <div className="w-24 text-right pt-1.5">
                                        <p className="text-xs text-muted-foreground">{format(new Date(entry.date), 'dd MMM')}</p>
                                        <p className="text-xs text-muted-foreground">{format(new Date(entry.date), 'hh:mm a')}</p>
                                    </div>
                                    <div className="flex-1 pt-1.5">
                                        <p className="font-semibold">{entry.status}</p>
                                        <p className="text-sm text-muted-foreground">{entry.location}</p>
                                    </div>
                                </div>
                            ))}
                        </div>
                    </CardContent>
                </Card>
            )}

        </div>
      </DashboardLayout>
    </SidebarProvider>
  );
}
