
'use client';

import { SidebarProvider } from '@/components/ui/sidebar';
import { DashboardLayout } from '@/components/dashboard-layout';
import type { BookingResult } from '@/lib/types';
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from '@/components/ui/card';
import { Button } from '@/components/ui/button';
import { Download } from 'lucide-react';
import { format } from 'date-fns';

type BalanceSheetSection = {
  title: string;
  items: { name: string; amount: number }[];
  total: number;
};

const assets: BalanceSheetSection = {
  title: "Assets",
  items: [
    { name: "Cash and Bank", amount: 605000 },
    { name: "Accounts Receivable - Merchants", amount: 250000 },
    { name: "Vehicles", amount: 1200000 },
  ],
  total: 2055000,
};

const liabilitiesAndEquity: BalanceSheetSection = {
  title: "Liabilities and Equity",
  items: [
    { name: "Accounts Payable - Vendors", amount: 150000 },
    { name: "Salaries Payable", amount: 200000 },
    { name: "Owner's Capital", amount: 1500000 },
    { name: "Retained Earnings", amount: 205000 },
  ],
  total: 2055000,
};

export default function BalanceSheetPage() {
  
  const handleBookingComplete = (result: BookingResult) => {};

  const BalanceSheetTable = ({ title, items, total }: BalanceSheetSection) => (
    <div>
      <h3 className="text-lg font-semibold p-3 bg-muted/50 border-b">{title}</h3>
      <div className="divide-y">
        {items.map(item => (
          <div key={item.name} className="flex justify-between items-center p-3">
            <span>{item.name}</span>
            <span className="font-mono">PKR {item.amount.toLocaleString()}</span>
          </div>
        ))}
      </div>
      <div className="flex justify-between items-center p-3 border-t-2 font-bold">
        <span>Total {title}</span>
        <span className="font-mono">PKR {total.toLocaleString()}</span>
      </div>
    </div>
  );

  return (
    <SidebarProvider>
      <DashboardLayout onBookingComplete={handleBookingComplete} userRole="finance">
        <div className="flex flex-col gap-8">
          <Card>
            <CardHeader>
               <div className="flex flex-col md:flex-row md:items-center justify-between gap-4">
                    <div>
                        <CardTitle>Balance Sheet</CardTitle>
                        <CardDescription>As of {format(new Date(), 'dd MMMM, yyyy')}</CardDescription>
                    </div>
                     <Button variant="outline"><Download className="mr-2 h-4 w-4" /> Export</Button>
                </div>
            </CardHeader>
            <CardContent>
                <div className="grid md:grid-cols-2 gap-8">
                    <BalanceSheetTable {...assets} />
                    <BalanceSheetTable {...liabilitiesAndEquity} />
                </div>
            </CardContent>
          </Card>
        </div>
      </DashboardLayout>
    </SidebarProvider>
  );
}
