
'use client';

import { useState } from 'react';
import { SidebarProvider } from '@/components/ui/sidebar';
import { DashboardLayout } from '@/components/dashboard-layout';
import type { BookingResult } from '@/lib/types';
import { Card, CardContent, CardDescription, CardHeader, CardTitle, CardFooter } from '@/components/ui/card';
import { Button } from '@/components/ui/button';
import { Table, TableBody, TableCell, TableHead, TableHeader, TableRow } from '@/components/ui/table';
import { Collapsible, CollapsibleContent, CollapsibleTrigger } from '@/components/ui/collapsible';
import { PlusCircle, ChevronsUpDown } from 'lucide-react';

type Account = {
  code: string;
  name: string;
  type: 'Asset' | 'Liability' | 'Equity' | 'Revenue' | 'Expense';
};

type AccountCategory = {
  name: 'Assets' | 'Liabilities' | 'Equity' | 'Revenue' | 'Expenses';
  accounts: Account[];
};

const chartOfAccountsData: AccountCategory[] = [
  {
    name: 'Assets',
    accounts: [
      { code: '1010', name: 'Cash and Bank', type: 'Asset' },
      { code: '1020', name: 'Accounts Receivable - Merchants', type: 'Asset' },
      { code: '1510', name: 'Vehicles', type: 'Asset' },
    ],
  },
  {
    name: 'Liabilities',
    accounts: [
      { code: '2010', name: 'Accounts Payable - Vendors', type: 'Liability' },
      { code: '2020', name: 'Salaries Payable', type: 'Liability' },
      { code: '2030', name: 'GST Payable', type: 'Liability' },
    ],
  },
  {
    name: 'Equity',
    accounts: [
      { code: '3010', name: 'Owner\'s Capital', type: 'Equity' },
      { code: '3020', name: 'Retained Earnings', type: 'Equity' },
    ],
  },
  {
    name: 'Revenue',
    accounts: [
      { code: '4010', name: 'Delivery Charges Income', type: 'Revenue' },
      { code: '4020', name: 'COD Handling Fees', type: 'Revenue' },
    ],
  },
  {
    name: 'Expenses',
    accounts: [
      { code: '5010', name: 'Salaries and Wages', type: 'Expense' },
      { code: '5020', name: 'Fuel and Maintenance', type: 'Expense' },
      { code: '5030', name: 'Rent Expense', type: 'Expense' },
    ],
  },
];


export default function ChartOfAccountsPage() {
  
  const handleBookingComplete = (result: BookingResult) => {};

  return (
    <SidebarProvider>
      <DashboardLayout onBookingComplete={handleBookingComplete} userRole="finance">
        <div className="flex flex-col gap-8">
          <Card>
            <CardHeader className="flex flex-row items-center">
                <div className="grid gap-2 flex-1">
                    <CardTitle>Chart of Accounts</CardTitle>
                    <CardDescription>
                    A structured list of all financial accounts in the general ledger.
                    </CardDescription>
                </div>
                <Button size="sm" className="ml-auto gap-1">
                    <PlusCircle className="h-4 w-4" />
                    Add Account
                </Button>
            </CardHeader>
            <CardContent>
              <div className="space-y-2">
                {chartOfAccountsData.map(category => (
                    <Collapsible key={category.name} defaultOpen>
                        <CollapsibleTrigger asChild>
                            <div className="flex w-full items-center justify-between rounded-md bg-muted p-3 font-semibold">
                                {category.name}
                                <ChevronsUpDown className="h-4 w-4" />
                            </div>
                        </CollapsibleTrigger>
                        <CollapsibleContent>
                            <div className="border-l border-r border-b rounded-b-md">
                                <Table>
                                    <TableHeader>
                                        <TableRow>
                                            <TableHead>Account Code</TableHead>
                                            <TableHead>Account Name</TableHead>
                                            <TableHead>Account Type</TableHead>
                                        </TableRow>
                                    </TableHeader>
                                    <TableBody>
                                        {category.accounts.map(account => (
                                            <TableRow key={account.code}>
                                                <TableCell className="font-mono">{account.code}</TableCell>
                                                <TableCell>{account.name}</TableCell>
                                                <TableCell>
                                                    <span className="text-xs text-muted-foreground">{account.type}</span>
                                                </TableCell>
                                            </TableRow>
                                        ))}
                                    </TableBody>
                                </Table>
                            </div>
                        </CollapsibleContent>
                    </Collapsible>
                ))}
              </div>
            </CardContent>
          </Card>
        </div>
      </DashboardLayout>
    </SidebarProvider>
  );
}

