
'use client';

import { useState } from 'react';
import { SidebarProvider } from '@/components/ui/sidebar';
import { DashboardLayout } from '@/components/dashboard-layout';
import type { BookingResult } from '@/lib/types';
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from '@/components/ui/card';
import { Button } from '@/components/ui/button';
import { Download } from 'lucide-react';
import { Select, SelectContent, SelectItem, SelectTrigger, SelectValue } from '@/components/ui/select';
import { addDays, format } from 'date-fns';
import { DatePickerWithRange } from '@/components/ui/date-range-picker';
import type { DateRange } from 'react-day-picker';

type PnlItem = {
    label: string;
    amount: number;
    isTotal?: boolean;
    isSubItem?: boolean;
    isNegative?: boolean;
};

const pnlData: PnlItem[] = [
    { label: 'Shipment Income', amount: 350000 },
    { label: 'COD Handling Fees', amount: 30000 },
    { label: 'Total Revenue', amount: 380000, isTotal: true },
    { label: 'Salaries and Wages', amount: 150000, isSubItem: true, isNegative: true },
    { label: 'Fuel and Maintenance', amount: 45000, isSubItem: true, isNegative: true },
    { label: 'Rent Expense', amount: 50000, isSubItem: true, isNegative: true },
    { label: 'Total Operating Expenses', amount: 245000, isTotal: true, isNegative: true },
    { label: 'Net Profit', amount: 135000, isTotal: true },
];

export default function PnlStatementPage() {
  
  const handleBookingComplete = (result: BookingResult) => {};

  const [dateRange, setDateRange] = useState<DateRange | undefined>({
    from: addDays(new Date(), -30),
    to: new Date(),
  });

  return (
    <SidebarProvider>
      <DashboardLayout onBookingComplete={handleBookingComplete} userRole="finance">
        <div className="flex flex-col gap-8">
          <Card>
            <CardHeader>
               <div className="flex flex-col md:flex-row md:items-center justify-between gap-4">
                    <div>
                        <CardTitle>Profit & Loss Statement</CardTitle>
                        <CardDescription>For the selected period</CardDescription>
                    </div>
                     <div className="flex gap-2">
                        <DatePickerWithRange date={dateRange} setDate={setDateRange} />
                        <Button variant="outline"><Download className="mr-2 h-4 w-4" /> Export</Button>
                    </div>
                </div>
            </CardHeader>
            <CardContent>
                <div className="max-w-4xl mx-auto border rounded-lg">
                    {pnlData.map((item, index) => (
                        <div 
                            key={index} 
                            className={`flex justify-between p-3 ${
                                item.isTotal ? 'font-bold border-t' : ''
                            } ${
                                index === pnlData.length - 1 ? 'bg-muted/50' : 'border-b'
                            }`}
                        >
                            <span className={item.isSubItem ? 'pl-4' : ''}>{item.label}</span>
                            <span className={`font-mono ${item.isNegative ? 'text-red-600' : ''}`}>
                                {item.isNegative ? `(PKR ${item.amount.toLocaleString()})` : `PKR ${item.amount.toLocaleString()}`}
                            </span>
                        </div>
                    ))}
                </div>
            </CardContent>
          </Card>
        </div>
      </DashboardLayout>
    </SidebarProvider>
  );
}
