
'use client';

import { SidebarProvider } from '@/components/ui/sidebar';
import { DashboardLayout } from '@/components/dashboard-layout';
import type { BookingResult } from '@/lib/types';
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from '@/components/ui/card';
import { Table, TableBody, TableCell, TableHead, TableHeader, TableRow, TableFooter } from '@/components/ui/table';
import { Button } from '@/components/ui/button';
import { Download } from 'lucide-react';
import { format } from 'date-fns';

type TrialBalanceEntry = {
    accountCode: string;
    accountName: string;
    debit: number;
    credit: number;
};

const trialBalanceData: TrialBalanceEntry[] = [
    { accountCode: '1010', accountName: 'Cash and Bank', debit: 605000, credit: 0 },
    { accountCode: '1020', accountName: 'Accounts Receivable - Merchants', debit: 250000, credit: 0 },
    { accountCode: '1510', accountName: 'Vehicles', debit: 1200000, credit: 0 },
    { accountCode: '2010', accountName: 'Accounts Payable - Vendors', debit: 0, credit: 150000 },
    { accountCode: '2020', accountName: 'Salaries Payable', debit: 0, credit: 200000 },
    { accountCode: '3010', accountName: 'Owner\'s Capital', debit: 0, credit: 1500000 },
    { accountCode: '3020', accountName: 'Retained Earnings', debit: 0, credit: 164500 },
    { accountCode: '4010', accountName: 'Delivery Charges Income', debit: 0, credit: 280000 },
    { accountCode: '5010', accountName: 'Salaries and Wages', debit: 200000, credit: 0 },
    { accountCode: '5020', accountName: 'Fuel and Maintenance', debit: 39500, credit: 0 },
];

const totalDebit = trialBalanceData.reduce((sum, item) => sum + item.debit, 0);
const totalCredit = trialBalanceData.reduce((sum, item) => sum + item.credit, 0);

export default function TrialBalancePage() {
  
  const handleBookingComplete = (result: BookingResult) => {};

  return (
    <SidebarProvider>
      <DashboardLayout onBookingComplete={handleBookingComplete} userRole="finance">
        <div className="flex flex-col gap-8">
          <Card>
            <CardHeader>
               <div className="flex flex-col md:flex-row md:items-center justify-between gap-4">
                    <div>
                        <CardTitle>Trial Balance</CardTitle>
                        <CardDescription>As of {format(new Date(), 'dd MMMM, yyyy')}</CardDescription>
                    </div>
                     <Button variant="outline"><Download className="mr-2 h-4 w-4" /> Export</Button>
                </div>
            </CardHeader>
            <CardContent>
              <Table>
                <TableHeader>
                    <TableRow>
                        <TableHead>Account Code</TableHead>
                        <TableHead>Account Name</TableHead>
                        <TableHead className="text-right">Debit (PKR)</TableHead>
                        <TableHead className="text-right">Credit (PKR)</TableHead>
                    </TableRow>
                </TableHeader>
                <TableBody>
                    {trialBalanceData.map(entry => (
                        <TableRow key={entry.accountCode}>
                            <TableCell className="font-mono">{entry.accountCode}</TableCell>
                            <TableCell>{entry.accountName}</TableCell>
                            <TableCell className="text-right font-mono">{entry.debit > 0 ? entry.debit.toLocaleString() : '-'}</TableCell>
                            <TableCell className="text-right font-mono">{entry.credit > 0 ? entry.credit.toLocaleString() : '-'}</TableCell>
                        </TableRow>
                    ))}
                </TableBody>
                <TableFooter>
                    <TableRow>
                        <TableCell colSpan={2} className="font-bold text-lg">Totals</TableCell>
                        <TableCell className="text-right font-bold text-lg font-mono">PKR {totalDebit.toLocaleString()}</TableCell>
                        <TableCell className="text-right font-bold text-lg font-mono">PKR {totalCredit.toLocaleString()}</TableCell>
                    </TableRow>
                </TableFooter>
              </Table>
            </CardContent>
          </Card>
        </div>
      </DashboardLayout>
    </SidebarProvider>
  );
}
