'use client';

import { SidebarProvider } from '@/components/ui/sidebar';
import { DashboardLayout } from '@/components/dashboard-layout';
import type { BookingResult } from '@/lib/types';
import { Card, CardContent, CardDescription, CardHeader, CardTitle, CardFooter } from '@/components/ui/card';
import { Landmark, PlusCircle } from 'lucide-react';
import { Button } from '@/components/ui/button';
import { Table, TableBody, TableCell, TableHead, TableHeader, TableRow } from '@/components/ui/table';

const linkedAccounts = [
    { id: 'hbl-1', bankName: 'HBL', accountNumber: '**** **** **** 1234', status: 'Active' },
    { id: 'mcb-1', bankName: 'MCB', accountNumber: '**** **** **** 5678', status: 'Active' },
];

export default function BankAccountsPage() {
  
  const handleBookingComplete = (result: BookingResult) => {};

  return (
    <SidebarProvider>
      <DashboardLayout onBookingComplete={handleBookingComplete} userRole="finance">
        <div className="flex flex-col gap-8">
          <Card>
            <CardHeader className="flex flex-row items-center">
              <div className="flex-1">
                <CardTitle>Bank Accounts Linked</CardTitle>
                <CardDescription>
                    Manage connections to your bank accounts for automated reconciliation.
                </CardDescription>
              </div>
              <Button size="sm" className="ml-auto gap-1">
                  <PlusCircle className="h-4 w-4" />
                  Add New Account
              </Button>
            </CardHeader>
            <CardContent>
                <Table>
                    <TableHeader>
                        <TableRow>
                            <TableHead>Bank Name</TableHead>
                            <TableHead>Account Number</TableHead>
                            <TableHead>Status</TableHead>
                            <TableHead className="text-right">Action</TableHead>
                        </TableRow>
                    </TableHeader>
                    <TableBody>
                        {linkedAccounts.map(account => (
                            <TableRow key={account.id}>
                                <TableCell className="font-medium">{account.bankName}</TableCell>
                                <TableCell>{account.accountNumber}</TableCell>
                                <TableCell>{account.status}</TableCell>
                                <TableCell className="text-right">
                                    <Button variant="outline" size="sm">Remove</Button>
                                </TableCell>
                            </TableRow>
                        ))}
                    </TableBody>
                </Table>
            </CardContent>
             <CardFooter>
                <p className="text-xs text-muted-foreground">
                    Connect your bank accounts to enable automated statement fetching and reconciliation.
                </p>
            </CardFooter>
          </Card>
        </div>
      </DashboardLayout>
    </SidebarProvider>
  );
}
