
'use client';

import { SidebarProvider } from '@/components/ui/sidebar';
import { DashboardLayout } from '@/components/dashboard-layout';
import type { BookingResult, Branch } from '@/lib/types';
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from '@/components/ui/card';
import { mockBranches } from '@/lib/data';
import { Table, TableBody, TableCell, TableHead, TableHeader, TableRow } from '@/components/ui/table';
import { Button } from '@/components/ui/button';
import { formatDistanceToNow } from 'date-fns';
import { Avatar, AvatarFallback, AvatarImage } from '@/components/ui/avatar';
import { Badge } from '@/components/ui/badge';

type PendingCodByBranch = {
    branch: Partial<Branch>;
    shipmentCount: number;
    totalCod: number;
    lastUpdate: string;
};

const pendingCodData: PendingCodByBranch[] = [
    { branch: { id: 'branch-1', name: 'Multan Main Branch', avatar: mockBranches[0].avatar }, shipmentCount: 25, totalCod: 45500, lastUpdate: new Date(Date.now() - 2 * 60 * 60 * 1000).toISOString() },
    { branch: { id: 'branch-2', name: 'Lahore Hub', avatar: mockBranches[1].avatar }, shipmentCount: 42, totalCod: 88300, lastUpdate: new Date(Date.now() - 4 * 60 * 60 * 1000).toISOString() },
    { branch: { id: 'branch-3', name: 'Karachi Central', avatar: mockBranches[2].avatar }, shipmentCount: 35, totalCod: 72400, lastUpdate: new Date(Date.now() - 1 * 60 * 60 * 1000).toISOString() },
];


export default function FinancePendingCodPage() {
  
  const handleBookingComplete = (result: BookingResult) => {};

  return (
    <SidebarProvider>
      <DashboardLayout onBookingComplete={handleBookingComplete} userRole="finance">
        <div className="flex flex-col gap-8">
          <Card>
            <CardHeader>
              <CardTitle>Pending COD by Branch</CardTitle>
              <CardDescription>
                A company-wide overview of all pending Cash on Delivery amounts awaiting deposit from branches.
              </CardDescription>
            </CardHeader>
            <CardContent>
               <Table>
                <TableHeader>
                    <TableRow>
                        <TableHead>Branch</TableHead>
                        <TableHead>Pending Shipments</TableHead>
                        <TableHead>Total Pending COD (PKR)</TableHead>
                        <TableHead>Last Update</TableHead>
                        <TableHead className="text-right">Action</TableHead>
                    </TableRow>
                </TableHeader>
                <TableBody>
                    {pendingCodData.map(item => (
                        <TableRow key={item.branch.id}>
                            <TableCell>
                                <div className="flex items-center gap-3">
                                    <Avatar>
                                        <AvatarImage src={item.branch.avatar} />
                                        <AvatarFallback>{item.branch.name?.charAt(0)}</AvatarFallback>
                                    </Avatar>
                                    <p className="font-medium">{item.branch.name}</p>
                                </div>
                            </TableCell>
                            <TableCell>
                                <Badge variant="secondary">{item.shipmentCount}</Badge>
                            </TableCell>
                            <TableCell className="font-medium">{item.totalCod.toLocaleString()}</TableCell>
                            <TableCell>{formatDistanceToNow(new Date(item.lastUpdate), { addSuffix: true })}</TableCell>
                            <TableCell className="text-right">
                                <Button size="sm" variant="outline">
                                    View Details
                                </Button>
                            </TableCell>
                        </TableRow>
                    ))}
                </TableBody>
              </Table>
            </CardContent>
          </Card>
        </div>
      </DashboardLayout>
    </SidebarProvider>
  );
}
