
'use client';

import { SidebarProvider } from '@/components/ui/sidebar';
import { DashboardLayout } from '@/components/dashboard-layout';
import type { BookingResult, Branch } from '@/lib/types';
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from '@/components/ui/card';
import { mockBranches } from '@/lib/data';
import { Table, TableBody, TableCell, TableHead, TableHeader, TableRow } from '@/components/ui/table';
import { Button } from '@/components/ui/button';
import { format } from 'date-fns';
import { Avatar, AvatarImage, AvatarFallback } from '@/components/ui/avatar';
import { Badge } from '@/components/ui/badge';

type ReconciledCod = {
    transactionId: string;
    branch: Partial<Branch>;
    amount: number;
    reconciliationDate: string;
    settlementBatchId: string;
    status: 'Paid to Merchant' | 'Completed';
};

const reconciledCodData: ReconciledCod[] = [
    { transactionId: 'REC-001', branch: { id: 'branch-1', name: 'Multan Main Branch', avatar: mockBranches[0].avatar }, amount: 45500, reconciliationDate: new Date(Date.now() - 2 * 24 * 60 * 60 * 1000).toISOString(), settlementBatchId: 'SET-BATCH-A', status: 'Paid to Merchant' },
    { transactionId: 'REC-002', branch: { id: 'branch-2', name: 'Lahore Hub', avatar: mockBranches[1].avatar }, amount: 88300, reconciliationDate: new Date(Date.now() - 3 * 24 * 60 * 60 * 1000).toISOString(), settlementBatchId: 'SET-BATCH-A', status: 'Paid to Merchant' },
    { transactionId: 'REC-003', branch: { id: 'branch-3', name: 'Karachi Central', avatar: mockBranches[2].avatar }, amount: 72400, reconciliationDate: new Date(Date.now() - 1 * 24 * 60 * 60 * 1000).toISOString(), settlementBatchId: 'SET-BATCH-B', status: 'Completed' },
];


export default function FinanceReconciledCodPage() {
  
  const handleBookingComplete = (result: BookingResult) => {};

  return (
    <SidebarProvider>
      <DashboardLayout onBookingComplete={handleBookingComplete} userRole="finance">
        <div className="flex flex-col gap-8">
          <Card>
            <CardHeader>
              <CardTitle>Reconciled COD</CardTitle>
              <CardDescription>
                View a history of all successfully reconciled Cash on Delivery transactions.
              </CardDescription>
            </CardHeader>
            <CardContent>
              <Table>
                <TableHeader>
                    <TableRow>
                        <TableHead>Transaction ID</TableHead>
                        <TableHead>Branch</TableHead>
                        <TableHead>Amount (PKR)</TableHead>
                        <TableHead>Reconciliation Date</TableHead>
                        <TableHead>Status</TableHead>
                        <TableHead className="text-right">Action</TableHead>
                    </TableRow>
                </TableHeader>
                <TableBody>
                    {reconciledCodData.map(item => (
                        <TableRow key={item.transactionId}>
                             <TableCell className="font-medium">{item.transactionId}</TableCell>
                            <TableCell>
                                <div className="flex items-center gap-3">
                                    <Avatar>
                                        <AvatarImage src={item.branch.avatar} />
                                        <AvatarFallback>{item.branch.name?.charAt(0)}</AvatarFallback>
                                    </Avatar>
                                    <p className="font-medium">{item.branch.name}</p>
                                </div>
                            </TableCell>
                            <TableCell>{item.amount.toLocaleString()}</TableCell>
                            <TableCell>{format(new Date(item.reconciliationDate), 'dd MMM, yyyy')}</TableCell>
                            <TableCell>
                                <Badge variant="secondary" className="bg-green-100 text-green-800">
                                    {item.status}
                                </Badge>
                            </TableCell>
                            <TableCell className="text-right">
                                <Button size="sm" variant="outline">
                                    View Batch
                                </Button>
                            </TableCell>
                        </TableRow>
                    ))}
                </TableBody>
              </Table>
            </CardContent>
          </Card>
        </div>
      </DashboardLayout>
    </SidebarProvider>
  );
}
