
'use client';

import { SidebarProvider } from '@/components/ui/sidebar';
import { DashboardLayout } from '@/components/dashboard-layout';
import type { BookingResult, Branch } from '@/lib/types';
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from '@/components/ui/card';
import { mockBranches } from '@/lib/data';
import { Table, TableBody, TableCell, TableHead, TableHeader, TableRow } from '@/components/ui/table';
import { Button } from '@/components/ui/button';
import { format } from 'date-fns';
import { Avatar, AvatarImage, AvatarFallback } from '@/components/ui/avatar';
import { Badge } from '@/components/ui/badge';

type TransferredCod = {
    transferId: string;
    branch: Partial<Branch>;
    amount: number;
    transferDate: string;
    status: 'In Transit' | 'Completed';
};

const transferredCodData: TransferredCod[] = [
    { transferId: 'TR-101', branch: { id: 'branch-1', name: 'Multan Main Branch', avatar: mockBranches[0].avatar }, amount: 45500, transferDate: new Date(Date.now() - 1 * 24 * 60 * 60 * 1000).toISOString(), status: 'Completed' },
    { transferId: 'TR-102', branch: { id: 'branch-2', name: 'Lahore Hub', avatar: mockBranches[1].avatar }, amount: 88300, transferDate: new Date(Date.now() - 2 * 24 * 60 * 60 * 1000).toISOString(), status: 'Completed' },
    { transferId: 'TR-103', branch: { id: 'branch-3', name: 'Karachi Central', avatar: mockBranches[2].avatar }, amount: 72400, transferDate: new Date().toISOString(), status: 'In Transit' },
];


export default function FinanceTransferredCodPage() {
  
  const handleBookingComplete = (result: BookingResult) => {};

  return (
    <SidebarProvider>
      <DashboardLayout onBookingComplete={handleBookingComplete} userRole="finance">
        <div className="flex flex-col gap-8">
          <Card>
            <CardHeader>
              <CardTitle>Transferred COD</CardTitle>
              <CardDescription>
                Track Cash on Delivery amounts transferred from branches to head office.
              </CardDescription>
            </CardHeader>
            <CardContent>
              <Table>
                <TableHeader>
                    <TableRow>
                        <TableHead>Transfer ID</TableHead>
                        <TableHead>Branch</TableHead>
                        <TableHead>Amount (PKR)</TableHead>
                        <TableHead>Transfer Date</TableHead>
                        <TableHead>Status</TableHead>
                        <TableHead className="text-right">Action</TableHead>
                    </TableRow>
                </TableHeader>
                <TableBody>
                    {transferredCodData.map(item => (
                        <TableRow key={item.transferId}>
                             <TableCell className="font-medium">{item.transferId}</TableCell>
                            <TableCell>
                                <div className="flex items-center gap-3">
                                    <Avatar>
                                        <AvatarImage src={item.branch.avatar} />
                                        <AvatarFallback>{item.branch.name?.charAt(0)}</AvatarFallback>
                                    </Avatar>
                                    <p className="font-medium">{item.branch.name}</p>
                                </div>
                            </TableCell>
                            <TableCell>{item.amount.toLocaleString()}</TableCell>
                            <TableCell>{format(new Date(item.transferDate), 'dd MMM, yyyy')}</TableCell>
                            <TableCell>
                                <Badge variant={item.status === 'Completed' ? 'secondary' : 'default'} className={item.status === 'In Transit' ? 'bg-blue-100 text-blue-800' : ''}>
                                    {item.status}
                                </Badge>
                            </TableCell>
                            <TableCell className="text-right">
                                <Button size="sm" variant="outline">
                                    View Details
                                </Button>
                            </TableCell>
                        </TableRow>
                    ))}
                </TableBody>
              </Table>
            </CardContent>
          </Card>
        </div>
      </DashboardLayout>
    </SidebarProvider>
  );
}
