
'use client';

import { useState } from 'react';
import { SidebarProvider } from '@/components/ui/sidebar';
import { DashboardLayout } from '@/components/dashboard-layout';
import type { BookingResult } from '@/lib/types';
import { Card, CardContent, CardDescription, CardHeader, CardTitle, CardFooter } from '@/components/ui/card';
import { Button } from '@/components/ui/button';
import { Table, TableBody, TableCell, TableHead, TableHeader, TableRow } from '@/components/ui/table';
import { MoreVertical, PlusCircle, Gift } from 'lucide-react';
import { DropdownMenu, DropdownMenuContent, DropdownMenuItem, DropdownMenuTrigger } from '@/components/ui/dropdown-menu';
import { Select, SelectContent, SelectItem, SelectTrigger, SelectValue } from '@/components/ui/select';
import { Input } from '@/components/ui/input';
import { useToast } from '@/hooks/use-toast';

type Bonus = {
    id: string;
    employeeName: string;
    amount: number;
    reason: string;
    payMonth: string;
};

const mockBonuses: Bonus[] = [
    { id: 'b-1', employeeName: 'Ahmed Hassan', amount: 5000, reason: 'Performance Bonus', payMonth: '2024-07' },
    { id: 'b-2', employeeName: 'Aisha Bibi', amount: 2500, reason: 'Eid Bonus', payMonth: '2024-06' },
];

const mockEmployees = [
    { id: 'emp-1', name: 'Ahmed Hassan' },
    { id: 'emp-2', name: 'Aisha Bibi' },
    { id: 'emp-3', name: 'Bilal Khan' },
]

export default function BonusAndIncentivesPage() {
  
  const handleBookingComplete = (result: BookingResult) => {};
  const [bonuses, setBonuses] = useState(mockBonuses);
  const { toast } = useToast();

  const handleAddBonus = () => {
    toast({ title: "Bonus Added", description: "The bonus has been successfully recorded."});
  }

  return (
    <SidebarProvider>
      <DashboardLayout onBookingComplete={handleBookingComplete} userRole="finance">
        <div className="flex flex-col gap-8">
            <Card>
                <CardHeader>
                    <CardTitle>Add Bonus or Incentive</CardTitle>
                    <CardDescription>Record a one-time bonus or a recurring incentive for an employee.</CardDescription>
                </CardHeader>
                <CardContent className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 items-end">
                    <div>
                        <label className="text-sm font-medium">Employee</label>
                        <Select><SelectTrigger><SelectValue placeholder="Select Employee" /></SelectTrigger>
                        <SelectContent>
                            {mockEmployees.map(e => <SelectItem key={e.id} value={e.id}>{e.name}</SelectItem>)}
                        </SelectContent>
                        </Select>
                    </div>
                     <div>
                        <label className="text-sm font-medium">Amount (PKR)</label>
                        <Input type="number" placeholder="Enter amount"/>
                    </div>
                     <div>
                        <label className="text-sm font-medium">Reason</label>
                        <Input placeholder="e.g., Performance Bonus"/>
                    </div>
                    <Button onClick={handleAddBonus} className="w-full md:w-auto">
                        <PlusCircle className="mr-2 h-4 w-4" /> Add to Payroll
                    </Button>
                </CardContent>
            </Card>

          <Card>
            <CardHeader>
                <CardTitle>Bonus & Incentive History</CardTitle>
                <CardDescription>
                A log of all bonuses and incentives paid to employees.
                </CardDescription>
            </CardHeader>
            <CardContent>
                <Table>
                    <TableHeader>
                        <TableRow>
                            <TableHead>Employee</TableHead>
                            <TableHead>Pay Month</TableHead>
                            <TableHead>Reason</TableHead>
                            <TableHead>Amount (PKR)</TableHead>
                            <TableHead className="text-right">Actions</TableHead>
                        </TableRow>
                    </TableHeader>
                    <TableBody>
                        {bonuses.map(bonus => (
                            <TableRow key={bonus.id}>
                                <TableCell className="font-medium">{bonus.employeeName}</TableCell>
                                <TableCell>{bonus.payMonth}</TableCell>
                                <TableCell>{bonus.reason}</TableCell>
                                <TableCell>{bonus.amount.toLocaleString()}</TableCell>
                                <TableCell className="text-right">
                                     <DropdownMenu>
                                        <DropdownMenuTrigger asChild>
                                            <Button size="icon" variant="ghost">
                                                <MoreVertical className="h-4 w-4" />
                                            </Button>
                                        </DropdownMenuTrigger>
                                        <DropdownMenuContent>
                                            <DropdownMenuItem>Edit</DropdownMenuItem>
                                            <DropdownMenuItem className="text-red-500">Cancel</DropdownMenuItem>
                                        </DropdownMenuContent>
                                    </DropdownMenu>
                                </TableCell>
                            </TableRow>
                        ))}
                    </TableBody>
                </Table>
            </CardContent>
          </Card>
        </div>
      </DashboardLayout>
    </SidebarProvider>
  );
}
