
'use client';

import { useState } from 'react';
import { SidebarProvider } from '@/components/ui/sidebar';
import { DashboardLayout } from '@/components/dashboard-layout';
import type { BookingResult } from '@/lib/types';
import { Card, CardContent, CardDescription, CardHeader, CardTitle, CardFooter } from '@/components/ui/card';
import { Button } from '@/components/ui/button';
import { Table, TableBody, TableCell, TableHead, TableHeader, TableRow } from '@/components/ui/table';
import { MoreVertical, PlusCircle } from 'lucide-react';
import { DropdownMenu, DropdownMenuContent, DropdownMenuItem, DropdownMenuTrigger } from '@/components/ui/dropdown-menu';
import { Avatar, AvatarFallback, AvatarImage } from '@/components/ui/avatar';
import { mockMarketingTeam } from '@/lib/data';

type EmployeeData = {
    id: string;
    name: string;
    avatar: string;
    designation: string;
    salary: number;
    bankAccount: string;
};

const mockEmployeeData: EmployeeData[] = [
    { id: 'emp-1', name: 'Ahmed Hassan', avatar: 'https://picsum.photos/seed/staff1/100', designation: 'Branch Operator', salary: 50000, bankAccount: '****-****-1234' },
    { id: 'emp-2', name: 'Aisha Bibi', avatar: 'https://picsum.photos/seed/staff2/100', designation: 'Branch Operator', salary: 48000, bankAccount: '****-****-5678' },
    { id: 'emp-3', name: 'Bilal Khan', avatar: 'https://picsum.photos/seed/staff3/100', designation: 'Rider', salary: 35000, bankAccount: '****-****-9012' },
];

export default function EmployeeMasterDataPage() {
  
  const handleBookingComplete = (result: BookingResult) => {};

  return (
    <SidebarProvider>
      <DashboardLayout onBookingComplete={handleBookingComplete} userRole="finance">
        <div className="flex flex-col gap-8">
          <Card>
            <CardHeader className="flex flex-row items-center">
                <div className="grid gap-2 flex-1">
                    <CardTitle>Employee Master Data</CardTitle>
                    <CardDescription>
                    Manage employee information for payroll processing.
                    </CardDescription>
                </div>
                <Button size="sm" className="ml-auto gap-1">
                    <PlusCircle className="h-4 w-4" />
                    Add Employee
                </Button>
            </CardHeader>
            <CardContent>
              <Table>
                <TableHeader>
                    <TableRow>
                        <TableHead>Employee</TableHead>
                        <TableHead>Designation</TableHead>
                        <TableHead>Basic Salary</TableHead>
                        <TableHead>Bank Account</TableHead>
                        <TableHead className="text-right">Actions</TableHead>
                    </TableRow>
                </TableHeader>
                <TableBody>
                    {mockEmployeeData.map(emp => (
                        <TableRow key={emp.id}>
                             <TableCell>
                                <div className="flex items-center gap-3">
                                    <Avatar>
                                        <AvatarImage src={emp.avatar} alt={emp.name} />
                                        <AvatarFallback>{emp.name.charAt(0)}</AvatarFallback>
                                    </Avatar>
                                    <p className="font-medium">{emp.name}</p>
                                </div>
                            </TableCell>
                            <TableCell>{emp.designation}</TableCell>
                            <TableCell>PKR {emp.salary.toLocaleString()}</TableCell>
                            <TableCell>{emp.bankAccount}</TableCell>
                            <TableCell className="text-right">
                                <DropdownMenu>
                                    <DropdownMenuTrigger asChild>
                                        <Button size="icon" variant="ghost">
                                            <MoreVertical className="h-4 w-4" />
                                        </Button>
                                    </DropdownMenuTrigger>
                                    <DropdownMenuContent>
                                        <DropdownMenuItem>Edit Details</DropdownMenuItem>
                                        <DropdownMenuItem>View Salary Structure</DropdownMenuItem>
                                        <DropdownMenuItem className="text-red-500">Deactivate</DropdownMenuItem>
                                    </DropdownMenuContent>
                                </DropdownMenu>
                            </TableCell>
                        </TableRow>
                    ))}
                </TableBody>
              </Table>
            </CardContent>
          </Card>
        </div>
      </DashboardLayout>
    </SidebarProvider>
  );
}
