
'use client';

import { useState } from 'react';
import { SidebarProvider } from '@/components/ui/sidebar';
import { DashboardLayout } from '@/components/dashboard-layout';
import type { BookingResult } from '@/lib/types';
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from '@/components/ui/card';
import { Button } from '@/components/ui/button';
import { Select, SelectContent, SelectItem, SelectTrigger, SelectValue } from '@/components/ui/select';
import { DatePickerWithRange } from '@/components/ui/date-range-picker';
import { FileSpreadsheet } from 'lucide-react';
import type { DateRange } from 'react-day-picker';
import { addDays } from 'date-fns';

export default function TaxDeductionReportsPage() {
  
  const handleBookingComplete = (result: BookingResult) => {};

  const [dateRange, setDateRange] = useState<DateRange | undefined>({
    from: addDays(new Date(), -30),
    to: new Date(),
  });
  const [taxType, setTaxType] = useState('all');

  return (
    <SidebarProvider>
      <DashboardLayout onBookingComplete={handleBookingComplete} userRole="finance">
        <div className="flex flex-col gap-8">
          <Card>
            <CardHeader>
              <CardTitle>Tax Deduction Reports</CardTitle>
              <CardDescription>
                Generate detailed reports for specific tax types and periods.
              </CardDescription>
            </CardHeader>
            <CardContent className="space-y-6">
                <div className="max-w-xl mx-auto space-y-4 p-6 border rounded-lg">
                    <div>
                        <label className="text-sm font-medium">Tax Type</label>
                        <Select value={taxType} onValueChange={setTaxType}>
                            <SelectTrigger>
                                <SelectValue placeholder="Select tax type" />
                            </SelectTrigger>
                            <SelectContent>
                                <SelectItem value="all">All Tax Types</SelectItem>
                                <SelectItem value="gst">GST</SelectItem>
                                <SelectItem value="income-tax">Income Tax Withholding</SelectItem>
                            </SelectContent>
                        </Select>
                    </div>
                     <div>
                        <label className="text-sm font-medium">Date Range</label>
                        <DatePickerWithRange date={dateRange} setDate={setDateRange} />
                    </div>
                    <Button className="w-full">
                        <FileSpreadsheet className="mr-2 h-4 w-4" />
                        Generate Report
                    </Button>
                </div>

                <div className="flex flex-col items-center justify-center text-center h-48 border-2 border-dashed rounded-lg bg-muted/50">
                    <h3 className="text-lg font-semibold text-muted-foreground">Your generated report will appear here</h3>
                    <p className="text-sm text-muted-foreground">Select criteria above to start.</p>
                </div>
            </CardContent>
          </Card>
        </div>
      </DashboardLayout>
    </SidebarProvider>
  );
}
