
'use client';

import { SidebarProvider } from '@/components/ui/sidebar';
import { DashboardLayout } from '@/components/dashboard-layout';
import type { BookingResult } from '@/lib/types';
import { Card, CardContent, CardDescription, CardHeader, CardTitle, CardFooter } from '@/components/ui/card';
import { Button } from '@/components/ui/button';
import { Input } from '@/components/ui/input';
import { Label } from '@/components/ui/label';
import { Save, Bot } from 'lucide-react';
import { useToast } from '@/hooks/use-toast';

export default function EFilingPage() {
  
  const handleBookingComplete = (result: BookingResult) => {};
  const { toast } = useToast();
  
  const handleSave = () => {
    toast({ title: 'Credentials Saved', description: 'Your e-filing credentials have been securely updated.'})
  }

  return (
    <SidebarProvider>
      <DashboardLayout onBookingComplete={handleBookingComplete} userRole="finance">
        <div className="flex flex-col gap-8">
          <Card>
            <CardHeader>
              <CardTitle>e-Filing Integration</CardTitle>
              <CardDescription>
                Connect to the FBR portal for automated tax submissions.
              </CardDescription>
            </CardHeader>
            <CardContent className="space-y-6">
                <Card className="bg-blue-50 border-blue-200">
                    <CardHeader className="flex flex-row items-start gap-4 space-y-0">
                        <Bot className="h-6 w-6 text-blue-600 flex-shrink-0" />
                        <div>
                             <CardTitle className="text-lg text-blue-900">Automation Coming Soon</CardTitle>
                             <CardDescription className="text-blue-800">
                                We are working on integrating directly with the FBR Iris portal for one-click tax submissions. 
                                For now, please configure your credentials below.
                            </CardDescription>
                        </div>
                    </CardHeader>
                </Card>
                <div className="max-w-md space-y-4">
                    <div>
                        <Label htmlFor="fbr-username">FBR Iris Username</Label>
                        <Input id="fbr-username" placeholder="Your FBR portal username" />
                    </div>
                     <div>
                        <Label htmlFor="fbr-password">FBR Iris Password</Label>
                        <Input id="fbr-password" type="password" placeholder="••••••••" />
                    </div>
                </div>
            </CardContent>
            <CardFooter>
                 <Button onClick={handleSave}>
                    <Save className="mr-2 h-4 w-4" />
                    Save Credentials
                </Button>
            </CardFooter>
          </Card>
        </div>
      </DashboardLayout>
    </SidebarProvider>
  );
}
