
'use client';

import { SidebarProvider } from '@/components/ui/sidebar';
import { DashboardLayout } from '@/components/dashboard-layout';
import type { BookingResult } from '@/lib/types';
import { Card, CardContent, CardDescription, CardHeader, CardTitle, CardFooter } from '@/components/ui/card';
import { Button } from '@/components/ui/button';
import { Table, TableBody, TableCell, TableHead, TableHeader, TableRow } from '@/components/ui/table';
import { Badge } from '@/components/ui/badge';
import { Upload, FileText } from 'lucide-react';
import { format } from 'date-fns';

type TaxFiling = {
  id: string;
  taxType: 'GST' | 'Income Tax';
  period: string;
  dueDate: string;
  filingDate: string | null;
  status: 'Pending' | 'Filed';
};

const mockFilings: TaxFiling[] = [
  { id: 'tf-1', taxType: 'GST', period: 'June 2024', dueDate: '2024-07-15', filingDate: '2024-07-14', status: 'Filed' },
  { id: 'tf-2', taxType: 'Income Tax', period: 'FY 2023-2024', dueDate: '2024-09-30', filingDate: null, status: 'Pending' },
  { id: 'tf-3', taxType: 'GST', period: 'July 2024', dueDate: '2024-08-15', filingDate: null, status: 'Pending' },
];

export default function TaxFilingsPage() {
  
  const handleBookingComplete = (result: BookingResult) => {};

  return (
    <SidebarProvider>
      <DashboardLayout onBookingComplete={handleBookingComplete} userRole="finance">
        <div className="flex flex-col gap-8">
          <Card>
            <CardHeader className="flex flex-row items-center">
              <div className="grid gap-2">
                <CardTitle>Tax Filings</CardTitle>
                <CardDescription>
                  Track and manage all tax return filings.
                </CardDescription>
              </div>
              <Button size="sm" className="ml-auto gap-1">
                <Upload className="h-4 w-4" />
                Log New Filing
              </Button>
            </CardHeader>
            <CardContent>
              <Table>
                <TableHeader>
                    <TableRow>
                        <TableHead>Tax Type</TableHead>
                        <TableHead>Period</TableHead>
                        <TableHead>Due Date</TableHead>
                        <TableHead>Filing Date</TableHead>
                        <TableHead>Status</TableHead>
                        <TableHead className="text-right">Action</TableHead>
                    </TableRow>
                </TableHeader>
                <TableBody>
                    {mockFilings.map(filing => (
                        <TableRow key={filing.id}>
                            <TableCell className="font-medium">{filing.taxType}</TableCell>
                            <TableCell>{filing.period}</TableCell>
                            <TableCell>{format(new Date(filing.dueDate), 'dd MMM, yyyy')}</TableCell>
                            <TableCell>{filing.filingDate ? format(new Date(filing.filingDate), 'dd MMM, yyyy') : 'N/A'}</TableCell>
                            <TableCell>
                                <Badge variant={filing.status === 'Filed' ? 'default' : 'destructive'} className={filing.status === 'Filed' ? 'bg-green-100 text-green-800' : ''}>
                                    {filing.status}
                                </Badge>
                            </TableCell>
                            <TableCell className="text-right">
                                <Button variant="outline" size="sm">
                                    <FileText className="mr-2 h-4 w-4" />
                                    View Details
                                </Button>
                            </TableCell>
                        </TableRow>
                    ))}
                </TableBody>
              </Table>
            </CardContent>
          </Card>
        </div>
      </DashboardLayout>
    </SidebarProvider>
  );
}
