
'use client';

import { SidebarProvider } from '@/components/ui/sidebar';
import { DashboardLayout } from '@/components/dashboard-layout';
import type { BookingResult, Seller } from '@/lib/types';
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from '@/components/ui/card';
import { Table, TableBody, TableCell, TableHead, TableHeader, TableRow } from '@/components/ui/table';
import { Button } from '@/components/ui/button';
import { mockSellers } from '@/lib/data';
import { Avatar, AvatarFallback, AvatarImage } from '@/components/ui/avatar';
import { format } from 'date-fns';

type MerchantWallet = {
    merchant: Seller;
    balance: number;
    totalPayouts: number;
    lastPayoutDate: string;
};

const walletData: MerchantWallet[] = [
    { merchant: mockSellers[0], balance: 12540.50, totalPayouts: 75000, lastPayoutDate: new Date(Date.now() - 7 * 24 * 60 * 60 * 1000).toISOString() },
    { merchant: mockSellers[1], balance: 8320.00, totalPayouts: 120000, lastPayoutDate: new Date(Date.now() - 5 * 24 * 60 * 60 * 1000).toISOString() },
];


export default function FinanceWalletsPage() {
  
  const handleBookingComplete = (result: BookingResult) => {};

  return (
    <SidebarProvider>
      <DashboardLayout onBookingComplete={handleBookingComplete} userRole="finance">
        <div className="flex flex-col gap-8">
          <Card>
            <CardHeader>
              <CardTitle>Merchant Wallets</CardTitle>
              <CardDescription>
                View merchant balances and manage payouts.
              </CardDescription>
            </CardHeader>
            <CardContent>
              <Table>
                <TableHeader>
                    <TableRow>
                        <TableHead>Merchant</TableHead>
                        <TableHead>Current Balance (PKR)</TableHead>
                        <TableHead>Total Payouts (PKR)</TableHead>
                        <TableHead>Last Payout Date</TableHead>
                        <TableHead className="text-right">Action</TableHead>
                    </TableRow>
                </TableHeader>
                <TableBody>
                    {walletData.map(item => (
                        <TableRow key={item.merchant.id}>
                            <TableCell>
                                <div className="flex items-center gap-3">
                                    <Avatar>
                                        <AvatarImage src={item.merchant.avatar} />
                                        <AvatarFallback>{item.merchant.name?.charAt(0)}</AvatarFallback>
                                    </Avatar>
                                    <div>
                                        <p className="font-medium">{item.merchant.name}</p>
                                        <p className="text-sm text-muted-foreground">{item.merchant.email}</p>
                                    </div>
                                </div>
                            </TableCell>
                            <TableCell className="font-semibold text-green-600">{item.balance.toLocaleString()}</TableCell>
                            <TableCell>{item.totalPayouts.toLocaleString()}</TableCell>
                            <TableCell>{format(new Date(item.lastPayoutDate), 'dd MMM, yyyy')}</TableCell>
                            <TableCell className="text-right">
                                <Button size="sm">Manage Payouts</Button>
                            </TableCell>
                        </TableRow>
                    ))}
                </TableBody>
              </Table>
            </CardContent>
          </Card>
        </div>
      </DashboardLayout>
    </SidebarProvider>
  );
}
