
'use client';

import { SidebarProvider } from '@/components/ui/sidebar';
import { DashboardLayout } from '@/components/dashboard-layout';
import type { BookingResult } from '@/lib/types';
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from '@/components/ui/card';
import { Users, FilePlus, CalendarCheck, WalletCards, TrendingUp, UserMinus, FolderOpen } from 'lucide-react';

export default function AdminHRDashboardPage() {
  
  const handleBookingComplete = (result: BookingResult) => {};
  
  const kpiCards = [
    { title: 'Total Employees', value: '150', icon: Users, description: 'All active staff members' },
    { title: 'Open Positions', value: '5', icon: FilePlus, description: 'Current job openings' },
    { title: 'On Leave Today', value: '8', icon: CalendarCheck, description: 'Staff on approved leave' },
    { title: 'Pending Payroll', value: '1', icon: WalletCards, description: 'Payroll run awaiting approval' },
    { title: 'Top Performer', value: 'Ali Khan', icon: TrendingUp, description: 'This month\'s highest rated employee' },
    { title: 'Exit Process', value: '2', icon: UserMinus, description: 'Employees currently in handover' },
  ];

  return (
    <SidebarProvider>
      <DashboardLayout onBookingComplete={handleBookingComplete} userRole="hr">
        <div className="flex flex-col gap-8">
          <Card>
            <CardHeader>
              <CardTitle>HR Dashboard</CardTitle>
              <CardDescription>
                An overview of all human resources activities and key metrics.
              </CardDescription>
            </CardHeader>
            <CardContent>
                <div className="grid gap-4 md:grid-cols-2 lg:grid-cols-3">
                    {kpiCards.map(card => (
                         <Card key={card.title}>
                            <CardHeader className="flex flex-row items-center justify-between space-y-0 pb-2">
                                <CardTitle className="text-sm font-medium">{card.title}</CardTitle>
                                <card.icon className="h-4 w-4 text-muted-foreground" />
                            </CardHeader>
                            <CardContent>
                                <div className="text-2xl font-bold">{card.value}</div>
                                <p className="text-xs text-muted-foreground">{card.description}</p>
                            </CardContent>
                        </Card>
                    ))}
                </div>
            </CardContent>
          </Card>
        </div>
      </DashboardLayout>
    </SidebarProvider>
  );
}
