
'use client';

import { SidebarProvider } from '@/components/ui/sidebar';
import { DashboardLayout } from '@/components/dashboard-layout';
import type { BookingResult } from '@/lib/types';
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from '@/components/ui/card';
import { FileKey } from 'lucide-react';

export default function AdminMarketingContractsVaultPage() {
  
  const handleBookingComplete = (result: BookingResult) => {};

  return (
    <SidebarProvider>
      <DashboardLayout onBookingComplete={handleBookingComplete} userRole="marketing-manager">
        <div className="flex flex-col gap-8">
          <Card>
            <CardHeader>
              <CardTitle>Merchant Contract Vault</CardTitle>
              <CardDescription>
                A secure digital vault for all signed merchant agreements.
              </CardDescription>
            </CardHeader>
            <CardContent>
              <div className="flex flex-col items-center justify-center text-center h-64 border-2 border-dashed rounded-lg bg-muted/50">
                    <FileKey className="h-12 w-12 text-muted-foreground mb-4" />
                    <h3 className="text-xl font-semibold text-muted-foreground">Feature Coming Soon</h3>
                    <p className="text-muted-foreground">The digital contract vault will be available here.</p>
                </div>
            </CardContent>
          </Card>
        </div>
      </DashboardLayout>
    </SidebarProvider>
  );
}
