
'use client';

import { SidebarProvider } from '@/components/ui/sidebar';
import { DashboardLayout } from '@/components/dashboard-layout';
import type { BookingResult, Parcel } from '@/lib/types';
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from '@/components/ui/card';
import { CheckCircle, History, Users, BarChart } from 'lucide-react';
import { useState, useEffect } from 'react';
import { mockParcels } from '@/lib/data';
import { DeliveryPerformanceChart } from '@/components/dashboard/delivery-performance-chart';

export default function AdminMarketingDashboardPage() {
    const [parcels, setParcels] = useState<Parcel[]>([]);

    useEffect(() => {
        setParcels(mockParcels);
    }, []);

    const handleBookingComplete = (result: BookingResult) => {
        if (result) {
            setParcels(prev => [result.parcel, ...prev]);
        }
    };

    const paidShipments = parcels.filter(p => p.status === 'Delivered').length;
    const pendingShipments = parcels.filter(p => p.status === 'Pending' || p.status === 'In Transit' || p.status === 'Picked Up').length;
    const topMerchants = 5; // Mock data

  return (
    <SidebarProvider>
      <DashboardLayout onBookingComplete={handleBookingComplete} userRole="marketing-manager">
        <div className="flex flex-col gap-8">
            <div className="grid gap-4 md:grid-cols-2 lg:grid-cols-3">
                <Card>
                    <CardHeader className="flex flex-row items-center justify-between space-y-0 pb-2">
                        <CardTitle className="text-sm font-medium">Paid Shipments (COD)</CardTitle>
                        <CheckCircle className="h-4 w-4 text-muted-foreground" />
                    </CardHeader>
                    <CardContent>
                        <div className="text-2xl font-bold">{paidShipments}</div>
                        <p className="text-xs text-muted-foreground">Total shipments with collected COD</p>
                    </CardContent>
                </Card>
                <Card>
                    <CardHeader className="flex flex-row items-center justify-between space-y-0 pb-2">
                        <CardTitle className="text-sm font-medium">Pending Shipments</CardTitle>
                        <History className="h-4 w-4 text-muted-foreground" />
                    </CardHeader>
                    <CardContent>
                        <div className="text-2xl font-bold">{pendingShipments}</div>
                        <p className="text-xs text-muted-foreground">Shipments currently in transit or pending</p>
                    </CardContent>
                </Card>
                 <Card>
                    <CardHeader className="flex flex-row items-center justify-between space-y-0 pb-2">
                        <CardTitle className="text-sm font-medium">Top Merchants</CardTitle>
                        <Users className="h-4 w-4 text-muted-foreground" />
                    </CardHeader>
                    <CardContent>
                        <div className="text-2xl font-bold">{topMerchants}</div>
                        <p className="text-xs text-muted-foreground">Merchants with highest paid COD volume</p>
                    </CardContent>
                </Card>
            </div>
            <Card>
                <CardHeader>
                    <CardTitle>Shipment Status Overview</CardTitle>
                    <CardDescription>A summary of all shipment statuses across the platform.</CardDescription>
                </CardHeader>
                <CardContent>
                    <DeliveryPerformanceChart parcels={parcels} />
                </CardContent>
            </Card>
        </div>
      </DashboardLayout>
    </SidebarProvider>
  );
}
