
'use client';

import { SidebarProvider } from '@/components/ui/sidebar';
import { DashboardLayout } from '@/components/dashboard-layout';
import type { BookingResult, Seller } from '@/lib/types';
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from '@/components/ui/card';
import { CircleDollarSign, Hourglass, CheckCircle } from 'lucide-react';
import { mockSellers } from '@/lib/data';
import { Table, TableBody, TableCell, TableHead, TableHeader, TableRow } from '@/components/ui/table';
import { Badge } from '@/components/ui/badge';
import { Avatar, AvatarFallback, AvatarImage } from '@/components/ui/avatar';
import { Button } from '@/components/ui/button';

type MerchantCodStatus = {
    merchant: Seller;
    pending: number;
    deposited: number;
    reconciled: number;
};

const mockCodStatus: MerchantCodStatus[] = [
    { merchant: mockSellers[0], pending: 15000, deposited: 45000, reconciled: 250000 },
    { merchant: mockSellers[1], pending: 22000, deposited: 80000, reconciled: 450000 },
];

export default function AdminMarketingCodStatusPage() {
  
  const handleBookingComplete = (result: BookingResult) => {};

  return (
    <SidebarProvider>
      <DashboardLayout onBookingComplete={handleBookingComplete} userRole="marketing-manager">
        <div className="flex flex-col gap-8">
          <Card>
            <CardHeader>
              <CardTitle>Merchant COD Status</CardTitle>
              <CardDescription>
                A live, read-only view of merchant-wise COD statuses: Pending, Deposited, and Reconciled.
              </CardDescription>
            </CardHeader>
            <CardContent>
                <Table>
                    <TableHeader>
                        <TableRow>
                            <TableHead>Merchant</TableHead>
                            <TableHead>Pending</TableHead>
                            <TableHead>Deposited</TableHead>
                            <TableHead>Reconciled</TableHead>
                            <TableHead className="text-right">Action</TableHead>
                        </TableRow>
                    </TableHeader>
                    <TableBody>
                        {mockCodStatus.map(status => (
                            <TableRow key={status.merchant.id}>
                                <TableCell>
                                    <div className="flex items-center gap-3">
                                        <Avatar className="h-10 w-10 border">
                                            <AvatarImage src={status.merchant.avatar} />
                                            <AvatarFallback>{status.merchant.name.charAt(0)}</AvatarFallback>
                                        </Avatar>
                                        <div>
                                            <p className="font-medium">{status.merchant.name}</p>
                                            <p className="text-sm text-muted-foreground">{status.merchant.email}</p>
                                        </div>
                                    </div>
                                </TableCell>
                                <TableCell>
                                     <Badge variant="outline" className="bg-yellow-100 text-yellow-800">
                                        <Hourglass className="mr-2 h-3 w-3" />
                                        PKR {status.pending.toLocaleString()}
                                    </Badge>
                                </TableCell>
                                <TableCell>
                                     <Badge variant="outline" className="bg-blue-100 text-blue-800">
                                        <CheckCircle className="mr-2 h-3 w-3" />
                                        PKR {status.deposited.toLocaleString()}
                                    </Badge>
                                </TableCell>
                                <TableCell>
                                     <Badge variant="outline" className="bg-green-100 text-green-800">
                                        <CircleDollarSign className="mr-2 h-3 w-3" />
                                        PKR {status.reconciled.toLocaleString()}
                                    </Badge>
                                </TableCell>
                                 <TableCell className="text-right">
                                    <Button variant="outline" size="sm">View Details</Button>
                                </TableCell>
                            </TableRow>
                        ))}
                    </TableBody>
                </Table>
            </CardContent>
          </Card>
        </div>
      </DashboardLayout>
    </SidebarProvider>
  );
}
