
'use client';

import { SidebarProvider } from '@/components/ui/sidebar';
import { DashboardLayout } from '@/components/dashboard-layout';
import type { BookingResult, Seller } from '@/lib/types';
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from '@/components/ui/card';
import { FileText, Download } from 'lucide-react';
import { Table, TableBody, TableCell, TableHead, TableHeader, TableRow } from '@/components/ui/table';
import { mockSellers } from '@/lib/data';
import { format } from 'date-fns';
import { Badge } from '@/components/ui/badge';
import { Button } from '@/components/ui/button';

type Invoice = {
  id: string;
  invoiceNumber: string;
  merchant: Seller;
  date: string;
  amount: number;
  status: 'Paid' | 'Unpaid';
};

const mockInvoices: Invoice[] = [
  { id: 'inv-1', invoiceNumber: 'INV-2024-001', merchant: mockSellers[0], date: '2024-07-15', amount: 45600, status: 'Paid' },
  { id: 'inv-2', invoiceNumber: 'INV-2024-002', merchant: mockSellers[1], date: '2024-07-18', amount: 78950, status: 'Unpaid' },
];

export default function AdminMarketingInvoicesPage() {
  
  const handleBookingComplete = (result: BookingResult) => {};

  return (
    <SidebarProvider>
      <DashboardLayout onBookingComplete={handleBookingComplete} userRole="marketing-manager">
        <div className="flex flex-col gap-8">
          <Card>
            <CardHeader>
              <CardTitle>Invoice Panel (Read-Only)</CardTitle>
              <CardDescription>
                A read-only view of merchant invoices generated and uploaded by the Finance department.
              </CardDescription>
            </CardHeader>
            <CardContent>
                 <Table>
                    <TableHeader>
                        <TableRow>
                            <TableHead>Invoice #</TableHead>
                            <TableHead>Merchant</TableHead>
                            <TableHead>Date</TableHead>
                            <TableHead>Status</TableHead>
                            <TableHead className="text-right">Amount (PKR)</TableHead>
                            <TableHead className="text-right">Action</TableHead>
                        </TableRow>
                    </TableHeader>
                    <TableBody>
                        {mockInvoices.map(invoice => (
                            <TableRow key={invoice.id}>
                                <TableCell className="font-medium text-primary">{invoice.invoiceNumber}</TableCell>
                                <TableCell>{invoice.merchant.name}</TableCell>
                                <TableCell>{format(new Date(invoice.date), 'dd MMM, yyyy')}</TableCell>
                                <TableCell>
                                    <Badge variant={invoice.status === 'Paid' ? 'default' : 'destructive'}>
                                        {invoice.status}
                                    </Badge>
                                </TableCell>
                                <TableCell className="text-right font-medium">{invoice.amount.toLocaleString()}</TableCell>
                                <TableCell className="text-right">
                                    <Button variant="outline" size="sm">
                                        <Download className="mr-2 h-4 w-4" />
                                        Download
                                    </Button>
                                </TableCell>
                            </TableRow>
                        ))}
                    </TableBody>
                </Table>
            </CardContent>
          </Card>
        </div>
      </DashboardLayout>
    </SidebarProvider>
  );
}
