
'use client';

import { useState } from 'react';
import { SidebarProvider } from '@/components/ui/sidebar';
import { DashboardLayout } from '@/components/dashboard-layout';
import type { BookingResult } from '@/lib/types';
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from '@/components/ui/card';
import { GitBranch, PlusCircle, Store, ChevronRight, ChevronDown } from 'lucide-react';
import { Button } from '@/components/ui/button';
import { Collapsible, CollapsibleContent, CollapsibleTrigger } from '@/components/ui/collapsible';

type SubAccount = {
  id: string;
  name: string;
  location: string;
};

type MainAccount = {
  id: string;
  name: string;
  subAccounts: SubAccount[];
};

const mockHierarchy: MainAccount[] = [
  {
    id: 'main-1',
    name: 'Fashion Forward Group',
    subAccounts: [
      { id: 'sub-1a', name: 'FFG - Lahore Outlet', location: 'Lahore' },
      { id: 'sub-1b', name: 'FFG - Karachi Warehouse', location: 'Karachi' },
      { id: 'sub-1c', name: 'FFG - Online Store', location: 'Online' },
    ],
  },
  {
    id: 'main-2',
    name: 'Gadget Galaxy',
    subAccounts: [
        { id: 'sub-2a', name: 'GG - Islamabad Store', location: 'Islamabad' },
    ]
  },
];


export default function AdminMarketingMerchantHierarchyPage() {
  
  const handleBookingComplete = (result: BookingResult) => {};

  return (
    <SidebarProvider>
      <DashboardLayout onBookingComplete={handleBookingComplete} userRole="marketing-manager">
        <div className="flex flex-col gap-8">
          <Card>
            <CardHeader className="flex flex-row items-center">
              <div className="grid gap-2">
                <CardTitle>Merchant Hierarchy</CardTitle>
                <CardDescription>
                  View and manage main accounts and sub-accounts for merchants with multiple stores.
                </CardDescription>
              </div>
              <Button size="sm" className="ml-auto gap-1">
                <PlusCircle className="h-4 w-4" />
                Add Account
              </Button>
            </CardHeader>
            <CardContent>
                <div className="space-y-4">
                    {mockHierarchy.map(mainAccount => (
                        <Collapsible key={mainAccount.id} defaultOpen className="border rounded-lg p-4">
                            <CollapsibleTrigger className="w-full flex items-center justify-between">
                                <div className="flex items-center gap-3">
                                    <GitBranch className="h-6 w-6 text-primary" />
                                    <h3 className="text-lg font-semibold">{mainAccount.name} (Main Account)</h3>
                                </div>
                                <Button variant="ghost" size="icon">
                                    <ChevronDown className="h-4 w-4" />
                                </Button>
                            </CollapsibleTrigger>
                            <CollapsibleContent className="pl-10 mt-4 space-y-3">
                                {mainAccount.subAccounts.map(subAccount => (
                                    <div key={subAccount.id} className="flex items-center gap-3 p-3 bg-muted/50 rounded-md">
                                        <Store className="h-5 w-5 text-muted-foreground" />
                                        <div>
                                            <p className="font-medium">{subAccount.name}</p>
                                            <p className="text-sm text-muted-foreground">{subAccount.location}</p>
                                        </div>
                                    </div>
                                ))}
                            </CollapsibleContent>
                        </Collapsible>
                    ))}
                </div>
            </CardContent>
          </Card>
        </div>
      </DashboardLayout>
    </SidebarProvider>
  );
}
