
'use client';

import { useState, useEffect } from 'react';
import { SidebarProvider } from '@/components/ui/sidebar';
import { DashboardLayout } from '@/components/dashboard-layout';
import { ParcelsTable } from '@/components/dashboard/parcels-table';
import { mockParcels } from '@/lib/data';
import type { BookingResult, Parcel } from '@/lib/types';
import { ETAPredictionDialog } from '@/components/eta-prediction-dialog';

export default function AllParcelsPage() {
  const [parcels, setParcels] = useState<Parcel[]>([]);
  const [bookingResult, setBookingResult] = useState<BookingResult>(null);

  useEffect(() => {
    setParcels(mockParcels);
  }, []);
  
  const handleBookingComplete = (result: BookingResult) => {
    if (result) {
      setParcels(prevParcels => [result.parcel, ...prevParcels]);
      setBookingResult(result);
    }
  };
  
  const handleCloseEtaDialog = () => {
    setBookingResult(null);
  }

  return (
    <SidebarProvider>
        <DashboardLayout onBookingComplete={handleBookingComplete} userRole='super-admin'>
            <div className="flex flex-col gap-8">
                <ParcelsTable parcels={parcels} title="All Shipments" description="A comprehensive view of all shipments across the platform." showViewAll={false} />
            </div>
        </DashboardLayout>
        <ETAPredictionDialog
            result={bookingResult}
            open={!!bookingResult}
            onOpenChange={(isOpen) => !isOpen && handleCloseEtaDialog()}
        />
    </SidebarProvider>
  );
}
