
'use client';

import { SidebarProvider } from '@/components/ui/sidebar';
import { DashboardLayout } from '@/components/dashboard-layout';
import type { BookingResult } from '@/lib/types';
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from '@/components/ui/card';
import { Ticket, CheckCircle, ShieldAlert, Smile, Meh, Frown, Bell } from 'lucide-react';
import { BarChart, Bar, XAxis, YAxis, Tooltip, ResponsiveContainer, CartesianGrid } from 'recharts';
import { ChartContainer, ChartTooltipContent } from '@/components/ui/chart';

const complaintCategories = [
    { name: 'Delivery Issues', count: 18 },
    { name: 'Finance', count: 12 },
    { name: 'Rider', count: 8 },
    { name: 'Return', count: 5 },
    { name: 'Others', count: 3 },
];

const liveAlerts = [
    { id: 'al-1', text: 'Merchant "Chic Boutique" COD pending > 7 days', priority: 'High' },
    { id: 'al-2', text: 'Rider "Ali Khan" has not responded in 12 hours', priority: 'High' },
    { id: 'al-3', text: 'Ticket #CMP-004 has been open for 48 hours without update', priority: 'Medium' },
];

export default function AdminSupportDashboardPage() {
  
  const handleBookingComplete = (result: BookingResult) => {};

  return (
    <SidebarProvider>
      <DashboardLayout onBookingComplete={handleBookingComplete} userRole="support">
        <div className="flex flex-col gap-8">
           <Card>
                <CardHeader>
                    <CardTitle>Support Dashboard</CardTitle>
                    <CardDescription>Overview of open complaints, SLAs, and key metrics.</CardDescription>
                </CardHeader>
                <CardContent className="space-y-8">
                    <div className="grid gap-4 md:grid-cols-2 lg:grid-cols-3">
                        <Card>
                            <CardHeader className="flex flex-row items-center justify-between space-y-0 pb-2">
                                <CardTitle className="text-sm font-medium">Open Tickets</CardTitle>
                                <Ticket className="h-4 w-4 text-muted-foreground" />
                            </CardHeader>
                            <CardContent>
                                <div className="text-2xl font-bold">42</div>
                                <p className="text-xs text-muted-foreground">Pending, In-progress, & Escalated</p>
                            </CardContent>
                        </Card>
                        <Card>
                            <CardHeader className="flex flex-row items-center justify-between space-y-0 pb-2">
                                <CardTitle className="text-sm font-medium">Resolved Today</CardTitle>
                                <CheckCircle className="h-4 w-4 text-muted-foreground" />
                            </CardHeader>
                            <CardContent>
                                <div className="text-2xl font-bold">15</div>
                                <p className="text-xs text-muted-foreground">Tickets closed today</p>
                            </CardContent>
                        </Card>
                        <Card>
                            <CardHeader className="flex flex-row items-center justify-between space-y-0 pb-2">
                                <CardTitle className="text-sm font-medium">SLA Breaches</CardTitle>
                                <ShieldAlert className="h-4 w-4 text-muted-foreground" />
                            </CardHeader>
                            <CardContent>
                                <div className="text-2xl font-bold">3</div>
                                <p className="text-xs text-muted-foreground">Tickets that have breached SLA</p>
                            </CardContent>
                        </Card>
                    </div>

                    <div>
                        <h3 className="text-lg font-semibold mb-4">Customer Sentiment Meter</h3>
                        <div className="grid gap-4 md:grid-cols-3">
                           <Card className="bg-green-50 border-green-200">
                                <CardHeader className="flex flex-row items-center justify-between space-y-0 pb-2">
                                    <CardTitle className="text-sm font-medium">Happy</CardTitle>
                                    <Smile className="h-4 w-4 text-green-600" />
                                </CardHeader>
                                <CardContent>
                                    <div className="text-2xl font-bold">75%</div>
                                </CardContent>
                            </Card>
                            <Card className="bg-yellow-50 border-yellow-200">
                                <CardHeader className="flex flex-row items-center justify-between space-y-0 pb-2">
                                    <CardTitle className="text-sm font-medium">Neutral</CardTitle>
                                    <Meh className="h-4 w-4 text-yellow-600" />
                                </CardHeader>
                                <CardContent>
                                    <div className="text-2xl font-bold">15%</div>
                                </CardContent>
                            </Card>
                            <Card className="bg-red-50 border-red-200">
                                <CardHeader className="flex flex-row items-center justify-between space-y-0 pb-2">
                                    <CardTitle className="text-sm font-medium">Angry</CardTitle>
                                    <Frown className="h-4 w-4 text-red-600" />
                                </CardHeader>
                                <CardContent>
                                    <div className="text-2xl font-bold">10%</div>
                                </CardContent>
                            </Card>
                        </div>
                    </div>
                    
                    <div className="grid md:grid-cols-2 gap-8">
                        <Card>
                            <CardHeader>
                                <CardTitle>Complaint Categories</CardTitle>
                                <CardDescription>A snapshot of the most common issue types.</CardDescription>
                            </CardHeader>
                            <CardContent>
                                <ChartContainer config={{}} className="h-64 w-full">
                                    <ResponsiveContainer>
                                        <BarChart data={complaintCategories} layout="vertical">
                                            <CartesianGrid strokeDasharray="3 3" />
                                            <XAxis type="number" />
                                            <YAxis dataKey="name" type="category" width={100} tickLine={false} axisLine={false} />
                                            <Tooltip content={<ChartTooltipContent />} />
                                            <Bar dataKey="count" fill="hsl(var(--primary))" radius={[0, 4, 4, 0]} />
                                        </BarChart>
                                    </ResponsiveContainer>
                                </ChartContainer>
                            </CardContent>
                        </Card>
                        <Card>
                            <CardHeader>
                                <CardTitle>Live Alerts</CardTitle>
                                <CardDescription>Urgent items that require immediate attention.</CardDescription>
                            </CardHeader>
                            <CardContent>
                                <div className="space-y-4">
                                    {liveAlerts.map(alert => (
                                        <div key={alert.id} className="flex items-start gap-3 p-3 rounded-lg bg-muted/50">
                                            <div className="flex h-8 w-8 items-center justify-center rounded-full bg-destructive/10 text-destructive">
                                                <Bell className="h-4 w-4"/>
                                            </div>
                                            <p className="text-sm flex-1">{alert.text}</p>
                                        </div>
                                    ))}
                                </div>
                            </CardContent>
                        </Card>
                    </div>

                </CardContent>
            </Card>
        </div>
      </DashboardLayout>
    </SidebarProvider>
  );
}
