
'use client';

import { SidebarProvider } from '@/components/ui/sidebar';
import { DashboardLayout } from '@/components/dashboard-layout';
import type { BookingResult } from '@/lib/types';
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from '@/components/ui/card';
import { Smile } from 'lucide-react';

export default function NpsDashboardPage() {
  
  const handleBookingComplete = (result: BookingResult) => {};

  return (
    <SidebarProvider>
      <DashboardLayout onBookingComplete={handleBookingComplete} userRole="support">
        <div className="flex flex-col gap-8">
          <Card>
            <CardHeader>
              <CardTitle>Net Promoter Score (NPS) Dashboard</CardTitle>
              <CardDescription>
                Track customer loyalty and satisfaction over time.
              </CardDescription>
            </CardHeader>
            <CardContent>
              <div className="flex flex-col items-center justify-center text-center h-64 border-2 border-dashed rounded-lg bg-muted/50">
                    <Smile className="h-12 w-12 text-muted-foreground mb-4" />
                    <h3 className="text-xl font-semibold text-muted-foreground">Feature Coming Soon</h3>
                    <p className="text-muted-foreground">The NPS dashboard and analytics will be available here.</p>
                </div>
            </CardContent>
          </Card>
        </div>
      </DashboardLayout>
    </SidebarProvider>
  );
}
