
'use client';

import { SidebarProvider } from '@/components/ui/sidebar';
import { DashboardLayout } from '@/components/dashboard-layout';
import type { BookingResult } from '@/lib/types';
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from '@/components/ui/card';

export default function CompanyNewsPage() {
  
  const handleBookingComplete = (result: BookingResult) => {};

  return (
    <SidebarProvider>
      <DashboardLayout onBookingComplete={handleBookingComplete} userRole="seller">
        <div className="flex flex-col gap-8">
          
          <Card>
            <CardHeader>
              <CardTitle>Company News & Updates</CardTitle>
              <CardDescription>
                Stay up-to-date with the latest news and announcements.
              </CardDescription>
            </CardHeader>
            <CardContent>
                <div className="flex flex-col items-center justify-center text-center h-64 border-2 border-dashed rounded-lg bg-muted/50">
                    <h3 className="text-xl font-semibold text-muted-foreground">No News Yet</h3>
                    <p className="text-muted-foreground">Check back later for the latest company updates.</p>
                </div>
            </CardContent>
          </Card>
        </div>
      </DashboardLayout>
    </SidebarProvider>
  );
}
