
'use client';

import { useState } from 'react';
import { SidebarProvider } from '@/components/ui/sidebar';
import { DashboardLayout } from '@/components/dashboard-layout';
import type { BookingResult } from '@/lib/types';
import { ETAPredictionDialog } from '@/components/eta-prediction-dialog';
import { BookParcelDialog } from '@/components/book-parcel-dialog';
import { Button } from '@/components/ui/button';
import { bookParcelAction } from '@/app/dashboard/actions';
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from '@/components/ui/card';
import { PlusCircle } from 'lucide-react';

export default function CreateOrderPage() {
  const [bookingResult, setBookingResult] = useState<BookingResult>(null);

  const handleBookingComplete = (result: BookingResult) => {
    if (result) {
      setBookingResult(result);
    }
  };

  const handleCloseEtaDialog = () => {
    setBookingResult(null);
  };

  return (
    <SidebarProvider>
      <DashboardLayout onBookingComplete={handleBookingComplete} userRole="seller" bookParcelAction={bookParcelAction}>
        <div className="flex flex-col gap-8">
          
           <Card>
            <CardHeader>
              <CardTitle>Create a New Shipment</CardTitle>
              <CardDescription>
                Click the button below to open the booking form and create a new shipment.
              </CardDescription>
            </CardHeader>
            <CardContent>
                <div className="flex items-center justify-center h-64 border-2 border-dashed rounded-lg bg-muted/50">
                    <BookParcelDialog onBookingComplete={handleBookingComplete} bookParcelAction={bookParcelAction}>
                      <Button size="lg" variant="accent">
                        <PlusCircle className="mr-2" />
                        Create a New Shipment
                      </Button>
                    </BookParcelDialog>
                </div>
            </CardContent>
          </Card>
        </div>
      </DashboardLayout>
      <ETAPredictionDialog
        result={bookingResult}
        open={!!bookingResult}
        onOpenChange={(isOpen) => !isOpen && handleCloseEtaDialog()}
      />
    </SidebarProvider>
  );
}
