
'use client';

import { useState } from 'react';
import { SidebarProvider } from '@/components/ui/sidebar';
import { DashboardLayout } from '@/components/dashboard-layout';
import type { BookingResult, Parcel } from '@/lib/types';
import { Card, CardContent, CardHeader, CardFooter } from '@/components/ui/card';
import { Button } from '@/components/ui/button';
import { Input } from '@/components/ui/input';
import { DatePicker } from '@/components/ui/date-picker';
import { Table, TableBody, TableCell, TableHead, TableHeader, TableRow } from '@/components/ui/table';
import { Select, SelectContent, SelectItem, SelectTrigger, SelectValue } from '@/components/ui/select';
import { Badge } from '@/components/ui/badge';
import { Search, RefreshCw, Printer, Download, Settings, UploadCloud } from 'lucide-react';
import { format } from 'date-fns';
import { DropdownMenu, DropdownMenuTrigger, DropdownMenuContent, DropdownMenuItem, DropdownMenuSub, DropdownMenuSubTrigger, DropdownMenuSubContent, DropdownMenuRadioGroup, DropdownMenuRadioItem, DropdownMenuLabel } from '@/components/ui/dropdown-menu';

type SearchType = 'order' | 'tracking' | 'name' | 'phone';

const allStatuses = [
    "All",
    "Unbooked",
    "Booked",
    "PostEx Warehouse",
    "Out For Delivery",
    "Delivered",
    "Returned",
    "Un-Assigned By Me",
    "Expired",
    "Delivery Under Review",
    "Picked By PostEx",
    "Out For Return",
    "Attempted",
    "Transferred",
];

export default function DestinationCityWisePage() {
  
  const handleBookingComplete = (result: BookingResult) => {};
  const [parcels] = useState<Parcel[]>([]);
  const [searchType, setSearchType] = useState<SearchType>('order');
  const [showCount, setShowCount] = useState("25");
  const [sortOrder, setSortOrder] = useState("desc");


  return (
    <SidebarProvider>
      <DashboardLayout onBookingComplete={handleBookingComplete} userRole="seller">
        <div className="flex flex-col gap-8">
          
            <Card>
                <CardHeader>
                    <div className="flex flex-wrap items-center justify-between gap-4">
                        <div className="flex items-center gap-2 border-b flex-wrap">
                            <Button variant="ghost" className="border-b-2 border-primary text-primary rounded-none">All (0)</Button>
                            <Button variant="ghost" className="text-muted-foreground rounded-none">Booked (0)</Button>
                            <Button variant="ghost" className="text-muted-foreground rounded-none">Unbooked (0)</Button>
                            <Button variant="ghost" className="text-muted-foreground rounded-none">InTransit (0)</Button>
                            <Button variant="ghost" className="text-muted-foreground rounded-none">Delivered (0)</Button>
                            <Button variant="ghost" className="text-muted-foreground rounded-none">Return In-Transit (0)</Button>
                            <Button variant="ghost" className="text-muted-foreground rounded-none">Returned (0)</Button>
                            <Button variant="ghost" className="text-muted-foreground rounded-none">Cancelled (0)</Button>
                            <Button variant="ghost" className="text-muted-foreground rounded-none">Expired (0)</Button>
                        </div>
                        <div className="flex items-center gap-2">
                            <Button variant="outline" size="icon"><RefreshCw className="h-4 w-4" /></Button>
                            <Button variant="outline" size="icon"><UploadCloud className="h-4 w-4" /></Button>
                            <Button variant="outline" size="icon"><Download className="h-4 w-4" /></Button>
                            <Button variant="outline" size="icon"><Printer className="h-4 w-4" /></Button>
                            <DropdownMenu>
                                <DropdownMenuTrigger asChild>
                                    <Button variant="outline" size="icon">
                                        <Settings className="h-4 w-4" />
                                    </Button>
                                </DropdownMenuTrigger>
                                <DropdownMenuContent align="end">
                                    <DropdownMenuLabel>Show</DropdownMenuLabel>
                                    <DropdownMenuRadioGroup value={showCount} onValueChange={setShowCount}>
                                        <DropdownMenuRadioItem value="25">25</DropdownMenuRadioItem>
                                        <DropdownMenuRadioItem value="50">50</DropdownMenuRadioItem>
                                        <DropdownMenuRadioItem value="100">100</DropdownMenuRadioItem>
                                        <DropdownMenuRadioItem value="200">200</DropdownMenuRadioItem>
                                        <DropdownMenuRadioItem value="300">300</DropdownMenuRadioItem>
                                        <DropdownMenuRadioItem value="all">All</DropdownMenuRadioItem>
                                    </DropdownMenuRadioGroup>
                                    <DropdownMenuLabel className="mt-2">Sort By Order Date</DropdownMenuLabel>
                                    <DropdownMenuRadioGroup value={sortOrder} onValueChange={setSortOrder}>
                                        <DropdownMenuRadioItem value="asc">ASC</DropdownMenuRadioItem>
                                        <DropdownMenuRadioItem value="desc">DESC</DropdownMenuRadioItem>
                                    </DropdownMenuRadioGroup>
                                </DropdownMenuContent>
                            </DropdownMenu>
                        </div>
                    </div>
                </CardHeader>
                <CardContent className="space-y-6">
                    <div className="p-4 border rounded-lg bg-muted/50">
                        <p className="text-sm font-semibold mb-4 text-muted-foreground">ADVANCED SEARCH</p>
                        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-4 items-end">
                            <div className="lg:col-span-2">
                                <label className="text-xs text-muted-foreground">Search by</label>
                                <div className="flex">
                                    <Input placeholder="Search..." className="rounded-r-none" />
                                     <Button 
                                        variant={searchType === 'order' ? 'secondary' : 'outline'}
                                        className="rounded-none border-l-0 px-2 h-10"
                                        onClick={() => setSearchType('order')}
                                    >ORDER #</Button>
                                     <Button 
                                        variant={searchType === 'tracking' ? 'secondary' : 'outline'}
                                        className="rounded-none border-l-0 border-r-0 px-2 h-10"
                                        onClick={() => setSearchType('tracking')}
                                    >TRACKING #</Button>
                                     <Button 
                                        variant={searchType === 'name' ? 'secondary' : 'outline'}
                                        className="rounded-none px-2 h-10"
                                        onClick={() => setSearchType('name')}
                                    >NAME</Button>
                                    <Button 
                                        variant={searchType === 'phone' ? 'secondary' : 'outline'}
                                        className="rounded-l-none rounded-r-md px-2 h-10"
                                        onClick={() => setSearchType('phone')}
                                    >PHONE #</Button>
                                </div>
                            </div>
                            <div>
                                <label className="text-xs text-muted-foreground">FROM</label>
                                <DatePicker />
                            </div>
                            <div>
                                <label className="text-xs text-muted-foreground">TO</label>
                                <DatePicker />
                            </div>
                             <div>
                                <label className="text-xs text-muted-foreground">STATUS</label>
                                <Select>
                                    <SelectTrigger><SelectValue placeholder="Select Status"/></SelectTrigger>
                                    <SelectContent>
                                        {allStatuses.map(status => (
                                            <SelectItem key={status} value={status}>{status}</SelectItem>
                                        ))}
                                    </SelectContent>
                                </Select>
                            </div>
                             <div>
                                <label className="text-xs text-muted-foreground">ORDER DATE TYPE</label>
                                <Select>
                                    <SelectTrigger><SelectValue placeholder="Select Order Date Type"/></SelectTrigger>
                                    <SelectContent>
                                        <SelectItem value="transaction-date">Transaction Date</SelectItem>
                                        <SelectItem value="pickup-date">PickUp Date</SelectItem>
                                        <SelectItem value="stock-in-picked-at">Stock In Picked At</SelectItem>
                                        <SelectItem value="status-changed-at">Order Status Changed At</SelectItem>
                                        <SelectItem value="booked-at">Booked At</SelectItem>
                                    </SelectContent>
                                </Select>
                            </div>
                            <div>
                                <label className="text-xs text-muted-foreground">DESTINATION CITY</label>
                                <Select>
                                    <SelectTrigger><SelectValue placeholder="ABBASPUR"/></SelectTrigger>
                                    <SelectContent>
                                        <SelectItem value="abbaspur">ABBASPUR</SelectItem>
                                    </SelectContent>
                                </Select>
                            </div>
                             <div className="flex items-end gap-2">
                                <Button className="w-full md:w-auto"><Search className="mr-2 h-4 w-4"/> Search</Button>
                                <Button variant="secondary" className="w-full md:w-auto">Clear Filter</Button>
                            </div>
                        </div>
                    </div>

                    <div className="overflow-x-auto">
                        <Table>
                            <TableHeader>
                                <TableRow>
                                    <TableHead>ORDER REF</TableHead>
                                    <TableHead>TRACKING #</TableHead>
                                    <TableHead>CUSTOMER</TableHead>
                                    <TableHead>WEIGHT</TableHead>
                                    <TableHead>ADDRESS</TableHead>
                                    <TableHead>ORIGIN CITY</TableHead>
                                    <TableHead>DELIVERY CITY</TableHead>
                                    <TableHead>DETAILS</TableHead>
                                    <TableHead className="text-right">AMOUNT</TableHead>
                                    <TableHead>STATUS</TableHead>
                                </TableRow>
                            </TableHeader>
                            <TableBody>
                                {parcels.length === 0 ? (
                                    <TableRow>
                                        <TableCell colSpan={10} className="h-24 text-center">No data to display.</TableCell>
                                    </TableRow>
                                ) : parcels.map(parcel => (
                                    <TableRow key={parcel.id}>
                                        <TableCell>{parcel.orderReferenceNumber}</TableCell>
                                        <TableCell>{parcel.id}</TableCell>
                                        <TableCell>{parcel.recipientName}</TableCell>
                                        <TableCell>{parcel.bookingWeight}kg</TableCell>
                                        <TableCell>{parcel.address}</TableCell>
                                        <TableCell>{parcel.pickupCity}</TableCell>
                                        <TableCell>{parcel.city}</TableCell>
                                        <TableCell>{parcel.orderDetail}</TableCell>
                                        <TableCell className="text-right">{parcel.codAmount.toFixed(2)}</TableCell>
                                        <TableCell><Badge variant="secondary">{parcel.status}</Badge></TableCell>
                                    </TableRow>
                                ))}
                            </TableBody>
                        </Table>
                    </div>
                </CardContent>
                 <CardFooter className="flex-col items-start gap-4 sm:flex-row sm:items-center sm:justify-between">
                     <p className="text-sm text-muted-foreground">Showing {parcels.length} of {parcels.length} entries</p>
                     <div className="flex items-center gap-2">
                        <span>Page</span>
                        <Select defaultValue="1">
                            <SelectTrigger className="w-16"><SelectValue /></SelectTrigger>
                            <SelectContent>
                                <SelectItem value="1">1</SelectItem>
                            </SelectContent>
                        </Select>
                        <span className="text-sm">of 1</span>
                        <Button variant="outline" size="sm" disabled>Previous</Button>
                        <Button variant="outline" size="sm" disabled>Next</Button>
                    </div>
                </CardFooter>
            </Card>
        </div>
      </DashboardLayout>
    </SidebarProvider>
  );
}
