
'use client';

import { useState } from 'react';
import { SidebarProvider } from '@/components/ui/sidebar';
import { DashboardLayout } from '@/components/dashboard-layout';
import type { BookingResult } from '@/lib/types';
import { Card, CardContent, CardDescription, CardHeader, CardTitle, CardFooter } from '@/components/ui/card';
import { Button } from '@/components/ui/button';
import { Search } from 'lucide-react';
import { Table, TableBody, TableCell, TableHead, TableHeader, TableRow } from '@/components/ui/table';
import { DatePicker } from '@/components/ui/date-picker';
import { format } from 'date-fns';
import { Input } from '@/components/ui/input';

type DigitalPayment = {
    id: string;
    transactionId: string;
    date: string;
    amount: number;
    method: string;
    status: 'Success' | 'Failed';
};

const mockPayments: DigitalPayment[] = [];

export default function DigitalPaymentsPage() {
  
  const handleBookingComplete = (result: BookingResult) => {};
  const [payments] = useState(mockPayments);

  return (
    <SidebarProvider>
      <DashboardLayout onBookingComplete={handleBookingComplete} userRole="seller">
        <div className="flex flex-col gap-8">
          
          <Card>
            <CardHeader>
              <CardTitle>Digital Payment Transactions</CardTitle>
              <CardDescription>
                View and manage your digital payment transactions.
              </CardDescription>
            </CardHeader>
            <CardContent className="space-y-6">
               <div className="p-4 border rounded-lg bg-muted/50">
                    <div className="grid grid-cols-1 md:grid-cols-4 gap-4 items-end">
                        <div>
                            <label className="text-xs text-muted-foreground">FROM</label>
                            <DatePicker />
                        </div>
                        <div>
                            <label className="text-xs text-muted-foreground">TO</label>
                            <DatePicker />
                        </div>
                        <div className="md:col-span-1">
                             <label className="text-xs text-muted-foreground">Transaction ID</label>
                             <Input placeholder="Search Transaction ID" />
                        </div>
                        <Button className="w-full md:w-auto"><Search className="mr-2 h-4 w-4"/> Search</Button>
                    </div>
                </div>
                <div className="overflow-x-auto">
                     <Table>
                        <TableHeader>
                            <TableRow>
                                <TableHead>Date</TableHead>
                                <TableHead>Transaction ID</TableHead>
                                <TableHead>Method</TableHead>
                                <TableHead>Status</TableHead>
                                <TableHead className="text-right">Amount (PKR)</TableHead>
                            </TableRow>
                        </TableHeader>
                        <TableBody>
                        {payments.length === 0 ? (
                            <TableRow>
                                <TableCell colSpan={5} className="h-24 text-center">No digital payments found.</TableCell>
                            </TableRow>
                        ) : payments.map((payment) => (
                            <TableRow key={payment.id}>
                                <TableCell>{format(new Date(payment.date), 'dd MMM, yyyy')}</TableCell>
                                <TableCell className="font-medium">{payment.transactionId}</TableCell>
                                <TableCell>{payment.method}</TableCell>
                                <TableCell>{payment.status}</TableCell>
                                <TableCell className="text-right">{payment.amount.toFixed(2)}</TableCell>
                            </TableRow>
                        ))}
                        </TableBody>
                    </Table>
                </div>
            </CardContent>
            <CardFooter className="flex-col items-start gap-4 sm:flex-row sm:items-center sm:justify-between">
                <p className="text-sm text-muted-foreground">Showing 1 to {payments.length} of {payments.length} entries</p>
                <div className="flex items-center gap-2">
                    <Button variant="outline" size="sm" disabled>Previous</Button>
                    <Button variant="outline" size="sm" disabled>Next</Button>
                </div>
            </CardFooter>
          </Card>
        </div>
      </DashboardLayout>
    </SidebarProvider>
  );
}

    
