
'use client';

import { useState } from 'react';
import { SidebarProvider } from '@/components/ui/sidebar';
import { DashboardLayout } from '@/components/dashboard-layout';
import type { BookingResult, Parcel } from '@/lib/types';
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from '@/components/ui/card';
import { Button } from '@/components/ui/button';

export default function IntegrationsPage() {
  const [bookingResult, setBookingResult] = useState<BookingResult>(null);

  const handleBookingComplete = (result: BookingResult) => {
    if (result) {
      setBookingResult(result);
    }
  };

  const ShopifyIcon = () => (
    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 81 91.5" className="h-8 w-8">
      <path
        fill="#96BF48"
        d="M62.6 48.9c-2.4 0-4.2 1.8-4.2 4.2 0 2.3 1.9 4.1 4.2 4.1s4.2-1.8 4.2-4.1c.1-2.4-1.8-4.2-4.2-4.2zm-44.2 0c-2.4 0-4.2 1.8-4.2 4.2.1-2.4-1.8-4.2-4.2-4.2zM81 23.4v60c0 4.5-3.6 8.1-8.1 8.1H8.1C3.6 91.5 0 87.9 0 83.4v-60c0-4.5 3.6-8.1 8.1-8.1h64.8c4.5 0 8.1 3.6 8.1 8.1zM62.6 28.5c-2.4 0-4.2 1.8-4.2 4.2 0 2.3 1.9 4.1 4.2 4.1s4.2-1.8 4.2-4.1c.1-2.3-1.8-4.2-4.2-4.2zm-44.2 0c-2.4 0-4.2 1.8-4.2 4.2 0 2.3 1.9 4.1 4.2 4.1 2.3 0 4.2-1.8 4.2-4.1.1-2.3-1.8-4.2-4.2-4.2zm44.2 41.2c-2.4 0-4.2 1.8-4.2 4.2 0 2.3 1.9 4.1 4.2 4.1s4.2-1.8 4.2-4.1c.1-2.4-1.8-4.2-4.2-4.2zm-44.2 0c-2.4 0-4.2 1.8-4.2 4.2 0 2.3 1.9 4.1 4.2 4.1 2.3 0 4.2-1.8 4.2-4.1.1-2.4-1.8-4.2-4.2-4.2zM62.6 8.7h-4.9c-2.7-5.1-8.1-8.7-14.2-8.7-6.1 0-11.5 3.5-14.2 8.7h-4.9c-2.6 0-4.8 2.2-4.8 4.8s2.2 4.8 4.8 4.8h4.9c.7 0 1.3-.2 1.9-.4 2.8-5.3 8.3-9 14.7-9s11.9 3.7 14.7 9c.6.2 1.2.4 1.9.4h4.9c2.6 0 4.8-2.2 4.8-4.8s-2.2-4.8-4.8-4.8z"
      />
    </svg>
  );

  return (
    <SidebarProvider>
      <DashboardLayout onBookingComplete={handleBookingComplete} userRole="seller">
        <div className="flex flex-col gap-8">
          
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
             <Card>
                <CardHeader className="flex flex-row items-center gap-4 space-y-0">
                  <ShopifyIcon />
                  <div>
                    <CardTitle>Shopify</CardTitle>
                    <CardDescription>
                      Connect your Shopify store to automatically import orders.
                    </CardDescription>
                  </div>
                </CardHeader>
                <CardContent>
                  <Button className="w-full">Connect</Button>
                </CardContent>
            </Card>
            <Card className="border-dashed">
                <CardHeader>
                    <CardTitle>More coming soon</CardTitle>
                    <CardDescription>
                        Integrations with other platforms are on the way.
                    </CardDescription>
                </CardHeader>
                <CardContent>
                    <Button variant="secondary" className="w-full" disabled>Coming Soon</Button>
                </CardContent>
            </Card>
          </div>
        </div>
      </DashboardLayout>
    </SidebarProvider>
  );
}
