

'use client';

import { useState } from 'react';
import { Button } from '@/components/ui/button';
import {
  Card,
  CardContent,
  CardDescription,
  CardFooter,
  CardHeader,
  CardTitle,
} from '@/components/ui/card';
import { Input } from '@/components/ui/input';
import { Label } from '@/components/ui/label';
import { Tabs, TabsContent, TabsList, TabsTrigger } from '@/components/ui/tabs';
import { SwiftSendLogo } from '@/components/icons';
import { ArrowRight } from 'lucide-react';
import Link from 'next/link';
import type { UserRole } from '@/lib/types';

export default function LoginPage() {
  const [role, setRole] = useState<UserRole>('seller');

  const handleLogin = () => {
    let redirectPath = '/dashboard'; // Default to seller
    if (role === 'super-admin') {
      redirectPath = '/admin';
    } else if (role === 'finance') {
        redirectPath = '/finance/dashboard';
    } else if (role === 'branch-operator') {
        redirectPath = '/admin/branch/dashboard';
    } else if (role === 'marketing') {
        redirectPath = '/admin/marketing/dashboard';
    } else if (role === 'support') {
        redirectPath = '/admin/support/dashboard';
    } else if (role === 'rider-manager') {
        redirectPath = '/admin/rider-manager/dashboard';
    } else if (role === 'hr') {
        redirectPath = '/admin/hr/dashboard';
    }
    window.location.href = redirectPath;
  };

  const LoginForm = ({ role, onLogin }: { role: UserRole, onLogin: () => void }) => (
    <CardContent className="space-y-4">
      <div className="space-y-2">
        <Label htmlFor={`${role}-email`}>Email</Label>
        <Input id={`${role}-email`} type="email" placeholder="m@example.com" required />
      </div>
      <div className="space-y-2">
        <div className="flex items-center">
          <Label htmlFor={`${role}-password`}>Password</Label>
          <Link href="#" className="ml-auto inline-block text-sm underline">
            Forgot your password?
          </Link>
        </div>
        <Input id={`${role}-password`} type="password" required />
      </div>
       <Button className="w-full" onClick={onLogin}>
            Sign in <ArrowRight className="ml-2" />
        </Button>
    </CardContent>
  );

  return (
    <div className="flex min-h-screen items-center justify-center bg-background p-4">
      <div className="w-full max-w-3xl">
        <div className="flex justify-center mb-6">
            <Link href="/" className="flex items-center gap-2">
                <SwiftSendLogo className="h-8 w-8 text-primary" />
                <h1 className="text-2xl font-bold">Al-wasi Soft Tech</h1>
            </Link>
        </div>
        <Tabs defaultValue="seller" className="w-full" onValueChange={(value) => setRole(value as UserRole)}>
          <TabsList className="grid w-full grid-cols-8">
            <TabsTrigger value="seller">Seller</TabsTrigger>
            <TabsTrigger value="super-admin">Super Admin</TabsTrigger>
            <TabsTrigger value="finance">Finance</TabsTrigger>
            <TabsTrigger value="branch-operator">Branch</TabsTrigger>
            <TabsTrigger value="marketing">Marketing</TabsTrigger>
            <TabsTrigger value="support">Support</TabsTrigger>
            <TabsTrigger value="rider-manager">Rider Manager</TabsTrigger>
            <TabsTrigger value="hr">HR</TabsTrigger>
          </TabsList>
          <TabsContent value="seller">
            <Card>
              <CardHeader>
                <CardTitle className="text-2xl">Seller Login</CardTitle>
                <CardDescription>
                  Enter your email below to login to your account.
                </CardDescription>
              </CardHeader>
              <LoginForm role="seller" onLogin={() => handleLogin()} />
              <CardFooter>
                <div className="text-center text-sm w-full">
                  Don&apos;t have an account?{' '}
                  <Link href="#" className="underline">
                    Sign up
                  </Link>
                </div>
              </CardFooter>
            </Card>
          </TabsContent>
          <TabsContent value="super-admin">
            <Card>
              <CardHeader>
                <CardTitle className="text-2xl">Super Admin Login</CardTitle>
                <CardDescription>
                    Enter your credentials to access the main admin dashboard.
                </CardDescription>
              </CardHeader>
              <LoginForm role="super-admin" onLogin={() => handleLogin()} />
            </Card>
          </TabsContent>
           <TabsContent value="finance">
            <Card>
              <CardHeader>
                <CardTitle className="text-2xl">Finance Login</CardTitle>
                <CardDescription>
                    Access the finance and tax module.
                </CardDescription>
              </CardHeader>
              <LoginForm role="finance" onLogin={() => handleLogin()} />
            </Card>
          </TabsContent>
           <TabsContent value="branch-operator">
            <Card>
              <CardHeader>
                <CardTitle className="text-2xl">Branch Login</CardTitle>
                <CardDescription>
                    Access the branch operations dashboard.
                </CardDescription>
              </CardHeader>
              <LoginForm role="branch-operator" onLogin={() => handleLogin()} />
            </Card>
          </TabsContent>
           <TabsContent value="marketing">
            <Card>
              <CardHeader>
                <CardTitle className="text-2xl">Marketing Login</CardTitle>
                <CardDescription>
                    Access the marketing and campaign dashboard.
                </CardDescription>
              </CardHeader>
              <LoginForm role="marketing" onLogin={() => handleLogin()} />
            </Card>
          </TabsContent>
           <TabsContent value="support">
            <Card>
              <CardHeader>
                <CardTitle className="text-2xl">Support Login</CardTitle>
                <CardDescription>
                    Access the customer support dashboard.
                </CardDescription>
              </CardHeader>
              <LoginForm role="support" onLogin={() => handleLogin()} />
            </Card>
          </TabsContent>
           <TabsContent value="rider-manager">
            <Card>
              <CardHeader>
                <CardTitle className="text-2xl">Rider Manager Login</CardTitle>
                <CardDescription>
                    Access the rider and operations dashboard.
                </CardDescription>
              </CardHeader>
              <LoginForm role="rider-manager" onLogin={() => handleLogin()} />
            </Card>
          </TabsContent>
           <TabsContent value="hr">
            <Card>
              <CardHeader>
                <CardTitle className="text-2xl">HR Login</CardTitle>
                <CardDescription>
                    Access the Human Resources dashboard.
                </CardDescription>
              </CardHeader>
              <LoginForm role="hr" onLogin={() => handleLogin()} />
            </Card>
          </TabsContent>
        </Tabs>
      </div>
    </div>
  );
}
