
'use client';

import { useState } from 'react';
import { SidebarProvider } from '@/components/ui/sidebar';
import { DashboardLayout } from '@/components/dashboard-layout';
import type { BookingResult } from '@/lib/types';
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from '@/components/ui/card';
import { Button } from '@/components/ui/button';
import { Smartphone, Download, Package, Wallet, Bell, CheckCircle } from 'lucide-react';
import Image from 'next/image';
import { Badge } from '@/components/ui/badge';

export default function MobileAppPage() {
  const [bookingResult, setBookingResult] = useState<BookingResult>(null);

  const handleBookingComplete = (result: BookingResult) => {
    if (result) {
      setBookingResult(result);
    }
  };

  const Feature = ({ icon: Icon, title, description }: { icon: React.ElementType, title: string, description: string }) => (
    <div className="flex items-start gap-4">
        <div className="flex h-10 w-10 items-center justify-center rounded-full bg-primary/10 text-primary">
            <Icon className="h-5 w-5" />
        </div>
        <div>
            <h3 className="font-semibold">{title}</h3>
            <p className="text-sm text-muted-foreground">{description}</p>
        </div>
    </div>
  );

  return (
    <SidebarProvider>
      <DashboardLayout onBookingComplete={handleBookingComplete} userRole="seller">
        <div className="flex flex-col gap-8">
          
          <Card className="overflow-hidden">
            <div className="grid md:grid-cols-2">
                <div className="p-6 md:p-8 flex flex-col justify-center">
                    <Badge variant="outline" className="w-fit mb-4"><Smartphone className="mr-2 h-4 w-4" />Coming Soon</Badge>
                    <CardTitle className="text-3xl font-bold">Manage Your Business on the Go</CardTitle>
                    <CardDescription className="mt-2 text-lg">
                        Our new mobile app, built with Flutter for both Android & iOS, is coming soon to help you manage your courier activities from anywhere.
                    </CardDescription>
                    <div className="mt-8 flex gap-4">
                        <Button disabled>
                          <svg xmlns="http://www.w3.org/2000/svg" className="h-5 w-5 mr-2" viewBox="0 0 24 24" fill="currentColor"><path d="M19.3 5.3C18.4 4.4 17.2 4 16 4s-2.4.4-3.3 1.3L12 6l-.7-.7C10.4 4.4 9.2 4 8 4S5.6 4.4 4.7 5.3C3.8 6.2 3.4 7.4 3.4 8.6c0 1.2.4 2.4 1.3 3.3l6.7 6.7 6.7-6.7c.9-.9 1.3-2.1 1.3-3.3s-.4-2.4-1.3-3.3zM7.1 11.2c-.5-.5-.7-1.1-.7-1.8 0-.7.2-1.3.7-1.8.5-.5 1.1-.7 1.8-.7s1.3.2 1.8.7l.7.7.7-.7c.5-.5 1.1-.7 1.8-.7s1.3.2 1.8.7c.5.5.7 1.1.7 1.8s-.2 1.3-.7 1.8L12 15.6l-4.9-4.4z" /></svg>
                            Google Play
                        </Button>
                        <Button disabled>
                          <svg xmlns="http://www.w3.org/2000/svg" className="h-5 w-5 mr-2" viewBox="0 0 24 24" fill="currentColor"><path d="M17.6 3c-1.5 0-2.9.6-3.9 1.6C12.8 3.6 11.4 3 9.9 3 7.2 3 5.1 5.1 5.1 7.8c0 1.4.6 2.7 1.6 3.7-1 .9-1.6 2.2-1.6 3.5 0 .2 0 .4.1.6 0 .1-.1.2-.1.3-.2.7-.3 1.5-.3 2.2 0 2.9 2.2 5.2 5 5.2 1.4 0 2.8-.6 3.8-1.6.9 1 2.3 1.6 3.7 1.6 2.7 0 4.9-2.2 4.9-4.9 0-1.4-.6-2.7-1.6-3.7 1-.9 1.6-2.2 1.6-3.5C22.5 5.2 20.3 3 17.6 3zm-7.7 1.5c.8 0 1.6.3 2.2.9.6.6.9 1.4.9 2.2s-.3 1.6-.9 2.2c-.6.6-1.4.9-2.2.9s-1.6-.3-2.2-.9c-.6-.6-.9-1.4-.9-2.2s.3-1.6.9-2.2c.6-.6 1.4-.9 2.2-.9z" /></svg>
                            App Store
                        </Button>
                    </div>
                </div>
                <div className="bg-muted/50 p-6 md:p-8 flex items-center justify-center">
                    <Image 
                        src="https://picsum.photos/seed/mobile-app/600/500" 
                        alt="Mobile App"
                        width={600}
                        height={500}
                        className="rounded-lg shadow-2xl"
                        data-ai-hint="app screenshot"
                     />
                </div>
            </div>
            <CardContent className="p-6 md:p-8">
                <h2 className="text-2xl font-semibold mb-6">Key Features</h2>
                <div className="grid gap-8 md:grid-cols-2 lg:grid-cols-3">
                    <Feature 
                        icon={Package} 
                        title="Easy Parcel Booking" 
                        description="Book single parcels manually or upload bulk parcels using a CSV file in just a few taps."
                    />
                    <Feature 
                        icon={Smartphone} 
                        title="Real-time Tracking"
                        description="Track your parcels in real-time and get updates at every step of the delivery process."
                    />
                    <Feature 
                        icon={Wallet} 
                        title="Wallet & Payouts"
                        description="View your COD wallet balance, request payouts, and track your payment history effortlessly."
                    />
                    <Feature 
                        icon={Download} 
                        title="Download Reports"
                        description="Get detailed reports for all your parcels and wallet transactions in PDF or Excel format."
                    />
                     <Feature 
                        icon={Bell} 
                        title="Push Notifications"
                        description="Receive instant push notifications for booking confirmations, delivery updates, and payouts."
                    />
                    <Feature 
                        icon={CheckCircle} 
                        title="Lightweight & Fast"
                        description="Enjoy a smooth and responsive experience, designed to work perfectly even on low-end devices."
                    />
                </div>
            </CardContent>
          </Card>
        </div>
      </DashboardLayout>
    </SidebarProvider>
  );
}
