
'use client';

import { useState } from 'react';
import { SidebarProvider } from '@/components/ui/sidebar';
import { DashboardLayout } from '@/components/dashboard-layout';
import type { BookingResult, PackagingRequest } from '@/lib/types';
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from '@/components/ui/card';
import { Button } from '@/components/ui/button';
import { PlusCircle } from 'lucide-react';
import { CreatePackagingRequestDialog } from '@/components/packaging/create-request-dialog';
import { useToast } from '@/hooks/use-toast';

export default function NewPackagingRequestPage() {
    const { toast } = useToast();

    const handleRequestCreated = (newRequest: PackagingRequest) => {
        toast({
            title: 'Request Submitted!',
            description: `Your packaging request for ${newRequest.quantity} items has been logged.`,
        });
    };

    return (
        <SidebarProvider>
            <DashboardLayout onBookingComplete={() => {}} userRole="seller">
                <div className="flex flex-col gap-8">
                    <Card>
                        <CardHeader>
                            <CardTitle>Request Packaging Material</CardTitle>
                            <CardDescription>
                                Click the button below to create a new request for packaging materials like flyers, boxes, and stickers.
                            </CardDescription>
                        </CardHeader>
                        <CardContent>
                            <div className="flex items-center justify-center h-64 border-2 border-dashed rounded-lg bg-muted/50">
                                <CreatePackagingRequestDialog onRequestCreated={handleRequestCreated}>
                                    <Button size="lg" variant="accent">
                                        <PlusCircle className="mr-2" />
                                        Create New Request
                                    </Button>
                                </CreatePackagingRequestDialog>
                            </div>
                        </CardContent>
                    </Card>
                </div>
            </DashboardLayout>
        </SidebarProvider>
    );
}
