
'use client';

import { useState } from 'react';
import { SidebarProvider } from '@/components/ui/sidebar';
import { DashboardLayout } from '@/components/dashboard-layout';
import type { BookingResult } from '@/lib/types';
import { Card, CardContent, CardDescription, CardHeader, CardTitle, CardFooter } from '@/components/ui/card';
import { Button } from '@/components/ui/button';
import { Input } from '@/components/ui/input';
import { Copy, Check } from 'lucide-react';
import { Separator } from '@/components/ui/separator';
import { Label } from '@/components/ui/label';
import { Tabs, TabsContent, TabsList, TabsTrigger } from '@/components/ui/tabs';
import { RadioGroup, RadioGroupItem } from '@/components/ui/radio-group';
import { mockUser } from '@/lib/data';
import { Table, TableBody, TableCell, TableHead, TableHeader, TableRow } from '@/components/ui/table';

const courierFees = [
    { city: 'Anytown', weight: '0.5', fee: 150 },
    { city: 'Anytown', weight: '1.0', fee: 200 },
    { city: 'Anytown', weight: '2.0', fee: 280 },
    { city: 'Otherville', weight: '0.5', fee: 180 },
    { city: 'Otherville', weight: '1.0', fee: 240 },
    { city: 'Otherville', weight: '2.0', fee: 320 },
];

export default function SettingsPage() {
  const [bookingResult, setBookingResult] = useState<BookingResult>(null);
  const [copied, setCopied] = useState(false);
  const apiKey = 'ss_sk_1234567890abcdef1234567890abcdef'; // Placeholder API key

  const handleBookingComplete = (result: BookingResult) => {
    if (result) {
      setBookingResult(result);
    }
  };

  const handleCopy = () => {
    navigator.clipboard.writeText(apiKey);
    setCopied(true);
    setTimeout(() => setCopied(false), 2000);
  };

  const ProfileInfoField = ({ label, value }: { label: string; value: string }) => (
    <div className="space-y-1">
        <Label htmlFor={label.toLowerCase().replace(' ', '-')}>{label}</Label>
        <Input id={label.toLowerCase().replace(' ', '-')} readOnly value={value} />
    </div>
  );

  return (
    <SidebarProvider>
      <DashboardLayout onBookingComplete={handleBookingComplete} userRole="seller">
        <div className="flex flex-col gap-8">
            <h1 className="text-2xl font-bold">Profile Details</h1>
            <Tabs defaultValue="profile">
              <TabsList className="grid w-full max-w-lg grid-cols-3">
                <TabsTrigger value="profile">My Profile</TabsTrigger>
                <TabsTrigger value="password">Change Password</TabsTrigger>
                <TabsTrigger value="notifications">Notifications</TabsTrigger>
              </TabsList>
              <TabsContent value="profile" className="mt-6 space-y-8">
                <Card>
                  <CardContent className="pt-6 grid grid-cols-1 md:grid-cols-2 gap-6">
                    <ProfileInfoField label="MERCHANT NAME" value={mockUser.companyName} />
                    <ProfileInfoField label="ACCOUNT ID" value={mockUser.id.replace('user-', '100000')} />
                    <ProfileInfoField label="EMAIL ADDRESS" value={mockUser.email} />
                    <ProfileInfoField label="MOBILE NUMBER" value="03344445283" />
                  </CardContent>
                </Card>

                <Card>
                    <CardHeader>
                        <CardTitle>Courier Fee Charges</CardTitle>
                        <CardDescription>
                            These are the delivery charges applicable to your shipments.
                        </CardDescription>
                    </CardHeader>
                    <CardContent>
                        <Table>
                            <TableHeader>
                                <TableRow>
                                    <TableHead>City</TableHead>
                                    <TableHead>Weight (KG)</TableHead>
                                    <TableHead className="text-right">Fee (PKR)</TableHead>
                                </TableRow>
                            </TableHeader>
                            <TableBody>
                                {courierFees.map((charge, index) => (
                                    <TableRow key={index}>
                                        <TableCell className="font-medium">{charge.city}</TableCell>
                                        <TableCell>{charge.weight}</TableCell>
                                        <TableCell className="text-right">{charge.fee.toFixed(2)}</TableCell>
                                    </TableRow>
                                ))}
                            </TableBody>
                        </Table>
                    </CardContent>
                </Card>

                <Card>
                    <CardHeader>
                        <CardTitle>Airway Bill Setting</CardTitle>
                    </CardHeader>
                    <CardContent className="space-y-6">
                        <div className="flex items-center gap-8">
                            <Label className="w-24">Size</Label>
                            <RadioGroup defaultValue="default" className="flex items-center gap-6">
                                <div className="flex items-center space-x-2">
                                    <RadioGroupItem value="4x6" id="size-4x6" />
                                    <Label htmlFor="size-4x6">4x6</Label>
                                </div>
                                <div className="flex items-center space-x-2">
                                    <RadioGroupItem value="default" id="size-default" />
                                    <Label htmlFor="size-default">Default</Label>
                                </div>
                                <div className="flex items-center space-x-2">
                                    <RadioGroupItem value="10x15" id="size-10x15" />
                                    <Label htmlFor="size-10x15">10x15</Label>
                                </div>
                            </RadioGroup>
                        </div>
                         <div className="flex items-center gap-8">
                            <Label className="w-24">Per page</Label>
                            <RadioGroup defaultValue="3" className="flex items-center gap-6">
                                <div className="flex items-center space-x-2">
                                    <RadioGroupItem value="1" id="per-page-1" />
                                    <Label htmlFor="per-page-1">1</Label>
                                </div>
                                <div className="flex items-center space-x-2">
                                    <RadioGroupItem value="2" id="per-page-2" />
                                    <Label htmlFor="per-page-2">2</Label>
                                </div>
                                <div className="flex items-center space-x-2">
                                    <RadioGroupItem value="3" id="per-page-3" />
                                    <Label htmlFor="per-page-3">3</Label>
                                </div>
                            </RadioGroup>
                        </div>
                    </CardContent>
                    <CardFooter className="justify-end">
                        <Button variant="accent">Save</Button>
                    </CardFooter>
                </Card>
              </TabsContent>
              <TabsContent value="password" className="mt-6">
                 <Card>
                    <CardHeader>
                        <CardTitle>Password Management</CardTitle>
                        <CardDescription>
                        Change your password here. We recommend using a strong, unique password.
                        </CardDescription>
                    </CardHeader>
                    <CardContent className="space-y-4">
                        <div className="space-y-2">
                        <Label htmlFor="current-password">Current Password</Label>
                        <Input id="current-password" type="password" />
                        </div>
                        <div className="space-y-2">
                        <Label htmlFor="new-password">New Password</Label>
                        <Input id="new-password" type="password" />
                        </div>
                        <div className="space-y-2">
                        <Label htmlFor="confirm-password">Confirm New Password</Label>
                        <Input id="confirm-password" type="password" />
                        </div>
                    </CardContent>
                    <CardFooter>
                        <Button>Update Password</Button>
                    </CardFooter>
                 </Card>
              </TabsContent>
              <TabsContent value="notifications" className="mt-6">
                 <Card>
                    <CardHeader>
                        <CardTitle>API Settings</CardTitle>
                        <CardDescription>
                        Manage your API keys for programmatic access to Al-wasi Soft Tech.
                        </CardDescription>
                    </CardHeader>
                    <CardContent className="space-y-4">
                        <div className="space-y-2">
                        <label className="text-sm font-medium">Your API Key</label>
                        <div className="flex items-center gap-2">
                            <Input type="text" readOnly value={apiKey} className="font-mono" />
                            <Button variant="outline" size="icon" onClick={handleCopy}>
                            {copied ? <Check className="h-4 w-4 text-green-500" /> : <Copy className="h-4 w-4" />}
                            </Button>
                        </div>
                        <p className="text-xs text-muted-foreground">
                            Use this key to authenticate your requests to the Al-wasi Soft Tech API.
                        </p>
                        </div>
                        <Separator />
                        <div className="space-y-2">
                        <Button variant="secondary">Regenerate API Key</Button>
                        <p className="text-xs text-muted-foreground">
                            Regenerating your key will invalidate the old one immediately.
                        </p>
                        </div>
                    </CardContent>
                    </Card>
              </TabsContent>
            </Tabs>
        </div>
      </DashboardLayout>
    </SidebarProvider>
  );
}
