
'use client';

import { useState } from 'react';
import { SidebarProvider } from '@/components/ui/sidebar';
import { DashboardLayout } from '@/components/dashboard-layout';
import type { BookingResult, Payout } from '@/lib/types';
import { Card, CardContent, CardHeader, CardFooter } from '@/components/ui/card';
import { Button } from '@/components/ui/button';
import { DatePicker } from '@/components/ui/date-picker';
import { Table, TableBody, TableCell, TableHead, TableHeader, TableRow } from '@/components/ui/table';
import { Search, RefreshCw, Printer, Download, Settings, UploadCloud } from 'lucide-react';
import { Input } from '@/components/ui/input';
import { Select, SelectContent, SelectItem, SelectTrigger, SelectValue } from '@/components/ui/select';
import { DropdownMenu, DropdownMenuTrigger, DropdownMenuContent, DropdownMenuItem, DropdownMenuSub, DropdownMenuSubTrigger, DropdownMenuSubContent, DropdownMenuRadioGroup, DropdownMenuRadioItem, DropdownMenuLabel } from '@/components/ui/dropdown-menu';

type Settlement = {
    id: string;
    trackingNumber: string;
    customer: string;
    codAmount: number;
    upFront: number;
    reserved: number;
    pickUp: number;
    delivery: number;
    balanceCod: number;
    upfrontCharges: number;
    gst: number;
    itwh: number;
    stwh: number;
    netAmount: number;
    status: string;
};

type SearchType = 'tracking' | 'name' | 'phone';

export default function SettlementLogsPage() {
  
  const handleBookingComplete = (result: BookingResult) => {};

  const [settlements] = useState<Settlement[]>([]);
  const [searchType, setSearchType] = useState<SearchType>('tracking');
  const [showCount, setShowCount] = useState("25");
  const [sortOrder, setSortOrder] = useState("desc");

  return (
    <SidebarProvider>
      <DashboardLayout onBookingComplete={handleBookingComplete} userRole="seller">
        <div className="flex flex-col gap-8">
          <Card>
            <CardHeader className="border-b">
               <div className="flex flex-wrap items-center justify-between gap-4">
                    <div className="flex items-center gap-2 border-b">
                        <Button variant="ghost" className="border-b-2 border-primary text-primary rounded-none">All ({settlements.length})</Button>
                        <Button variant="ghost" className="text-muted-foreground rounded-none">Delivered (0)</Button>
                        <Button variant="ghost" className="text-muted-foreground rounded-none">Return (0)</Button>
                    </div>
                    <div className="flex items-center gap-2">
                        <Button variant="outline" size="icon"><RefreshCw className="h-4 w-4" /></Button>
                        <Button variant="outline" size="icon"><UploadCloud className="h-4 w-4" /></Button>
                        <Button variant="outline" size="icon"><Download className="h-4 w-4" /></Button>
                        <Button variant="outline" size="icon"><Printer className="h-4 w-4" /></Button>
                        <DropdownMenu>
                            <DropdownMenuTrigger asChild>
                                <Button variant="outline" size="icon">
                                    <Settings className="h-4 w-4" />
                                </Button>
                            </DropdownMenuTrigger>
                            <DropdownMenuContent align="end">
                                <DropdownMenuLabel>Show</DropdownMenuLabel>
                                <DropdownMenuRadioGroup value={showCount} onValueChange={setShowCount}>
                                    <DropdownMenuRadioItem value="25">25</DropdownMenuRadioItem>
                                    <DropdownMenuRadioItem value="50">50</DropdownMenuRadioItem>
                                    <DropdownMenuRadioItem value="100">100</DropdownMenuRadioItem>
                                    <DropdownMenuRadioItem value="200">200</DropdownMenuRadioItem>
                                    <DropdownMenuRadioItem value="300">300</DropdownMenuRadioItem>
                                    <DropdownMenuRadioItem value="all">All</DropdownMenuRadioItem>
                                </DropdownMenuRadioGroup>
                                <DropdownMenuLabel className="mt-2">Sort By Order Date</DropdownMenuLabel>
                                <DropdownMenuRadioGroup value={sortOrder} onValueChange={setSortOrder}>
                                    <DropdownMenuRadioItem value="asc">ASC</DropdownMenuRadioItem>
                                    <DropdownMenuRadioItem value="desc">DESC</DropdownMenuRadioItem>
                                </DropdownMenuRadioGroup>
                            </DropdownMenuContent>
                        </DropdownMenu>
                    </div>
                </div>
            </CardHeader>
            <CardContent className="space-y-6 pt-6">
                <div className="p-4 border rounded-lg bg-muted/50">
                    <p className="text-sm font-semibold mb-4 text-muted-foreground">ADVANCED SEARCH</p>
                    <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 items-end">
                        <div className="lg:col-span-2">
                            <label className="text-xs text-muted-foreground">Search by</label>
                            <div className="flex">
                                <Input placeholder="Search..." className="rounded-r-none" />
                                <Button 
                                    variant={searchType === 'tracking' ? 'secondary' : 'outline'}
                                    className="rounded-none border-l-0"
                                    onClick={() => setSearchType('tracking')}
                                >
                                    TRACKING #
                                </Button>
                                <Button 
                                    variant={searchType === 'name' ? 'secondary' : 'outline'} 
                                    className="rounded-none"
                                    onClick={() => setSearchType('name')}
                                >
                                    NAME
                                </Button>
                                <Button 
                                    variant={searchType === 'phone' ? 'secondary' : 'outline'} 
                                    className="rounded-l-none"
                                    onClick={() => setSearchType('phone')}
                                >
                                    PHONE #
                                </Button>
                            </div>
                        </div>
                        <div>
                            <label className="text-xs text-muted-foreground">FROM</label>
                            <DatePicker />
                        </div>
                        <div>
                            <label className="text-xs text-muted-foreground">TO</label>
                            <DatePicker />
                        </div>
                        <div className="flex items-center gap-2">
                           <Button className="w-full"><Search className="mr-2 h-4 w-4"/> Search</Button>
                           <Button variant="secondary" className="w-full">Clear Filter</Button>
                        </div>
                    </div>
                </div>
                 <div className="overflow-x-auto">
                    <Table>
                        <TableHeader>
                            <TableRow>
                                <TableHead>TRACKING #</TableHead>
                                <TableHead>CUSTOMER</TableHead>
                                <TableHead>COD AMOUNT</TableHead>
                                <TableHead>UP FRONT</TableHead>
                                <TableHead>RESERVED</TableHead>
                                <TableHead>PICK UP</TableHead>
                                <TableHead>DELIVERY</TableHead>
                                <TableHead>BALANCE COD AMOUNT</TableHead>
                                <TableHead>UPFRONT CHARGES</TableHead>
                                <TableHead>GST</TableHead>
                                <TableHead>ITWH (2%)</TableHead>
                                <TableHead>STWH (2%)</TableHead>
                                <TableHead>NET AMOUNT</TableHead>
                                <TableHead>STATUS</TableHead>
                                <TableHead>ACTION</TableHead>
                            </TableRow>
                        </TableHeader>
                        <TableBody>
                        {settlements.length === 0 ? (
                            <TableRow>
                                <TableCell colSpan={15} className="h-24 text-center">No settlements found.</TableCell>
                            </TableRow>
                        ) : settlements.map((s) => (
                            <TableRow key={s.id}>
                               <TableCell>{s.trackingNumber}</TableCell>
                                <TableCell>{s.customer}</TableCell>
                                <TableCell>{s.codAmount}</TableCell>
                                <TableCell>{s.upFront}</TableCell>
                                <TableCell>{s.reserved}</TableCell>
                                <TableCell>{s.pickUp}</TableCell>
                                <TableCell>{s.delivery}</TableCell>
                                <TableCell>{s.balanceCod}</TableCell>
                                <TableCell>{s.upfrontCharges}</TableCell>
                                <TableCell>{s.gst}</TableCell>
                                <TableCell>{s.itwh}</TableCell>
                                <TableCell>{s.stwh}</TableCell>
                                <TableCell>{s.netAmount}</TableCell>
                                <TableCell>{s.status}</TableCell>
                                <TableCell>{/* Action button here */}</TableCell>
                            </TableRow>
                        ))}
                        </TableBody>
                    </Table>
                </div>
            </CardContent>
            <CardFooter className="flex-col items-start gap-4 sm:flex-row sm:items-center sm:justify-between">
                <p className="text-sm text-muted-foreground">Showing 0 of 0 entries</p>
                 <div className="flex items-center gap-2">
                        <span>Page</span>
                        <Select defaultValue="1">
                            <SelectTrigger className="w-16"><SelectValue /></SelectTrigger>
                            <SelectContent>
                                <SelectItem value="1">1</SelectItem>
                            </SelectContent>
                        </Select>
                        <span className="text-sm">of 0</span>
                        <Button variant="outline" size="sm" disabled>Previous</Button>
                        <Button variant="outline" size="sm" disabled>Next</Button>
                    </div>
            </CardFooter>
          </Card>
        </div>
      </DashboardLayout>
    </SidebarProvider>
  );
}
