
'use client';

import { useState } from 'react';
import { SidebarProvider } from '@/components/ui/sidebar';
import { DashboardLayout } from '@/components/dashboard-layout';
import type { BookingResult } from '@/lib/types';
import { Card, CardContent, CardHeader, CardFooter } from '@/components/ui/card';
import { Button } from '@/components/ui/button';
import { Download, Search, RefreshCw, Printer, Trash2, MoreVertical, Settings } from 'lucide-react';
import { Table, TableBody, TableCell, TableHead, TableHeader, TableRow } from '@/components/ui/table';
import { Select, SelectContent, SelectItem, SelectTrigger, SelectValue } from '@/components/ui/select';
import { DatePicker } from '@/components/ui/date-picker';
import { Input } from '@/components/ui/input';
import { DropdownMenu, DropdownMenuContent, DropdownMenuItem, DropdownMenuTrigger } from '@/components/ui/dropdown-menu';
import Link from 'next/link';

type Invoice = {
    id: string;
    invoiceNumber: string;
    date: string;
    amount: number;
    status: 'Paid' | 'Unpaid';
};

const mockInvoices: Invoice[] = [
    { id: '1', invoiceNumber: 'INV-001', date: '2024-07-15', amount: 4500.00, status: 'Paid'},
    { id: '2', invoiceNumber: 'INV-002', date: '2024-07-18', amount: 3200.50, status: 'Unpaid'},
    { id: '3', invoiceNumber: 'INV-003', date: '2024-07-22', amount: 8900.00, status: 'Paid'},
];

export default function TaxInvoicesPage() {
  
  const handleBookingComplete = (result: BookingResult) => {};
  const [invoices] = useState(mockInvoices);

  return (
    <SidebarProvider>
      <DashboardLayout onBookingComplete={handleBookingComplete} userRole="seller">
        <div className="flex flex-col gap-8">
             <div className="flex items-center justify-end">
                <div className="flex items-center gap-2">
                    <Button variant="outline" size="icon"><RefreshCw className="h-4 w-4" /></Button>
                    <Button variant="outline" size="icon"><Printer className="h-4 w-4" /></Button>
                    <Button variant="outline" size="icon"><Trash2 className="h-4 w-4" /></Button>
                </div>
            </div>
          <Card>
            <CardHeader className="p-4 border-b">
               <div className="p-4 rounded-lg">
                    <p className="text-sm font-semibold mb-4 text-muted-foreground">ADVANCED SEARCH</p>
                    <div className="grid grid-cols-1 md:grid-cols-4 gap-4 items-end">
                        <div className="md:col-span-2">
                            <label className="text-xs text-muted-foreground">Search by</label>
                            <div className="flex">
                                <Input placeholder="Search..." className="rounded-r-none" />
                                <Button variant="secondary" className="rounded-l-none border-l-0">INVOICE#</Button>
                            </div>
                        </div>
                        <div>
                            <label className="text-xs text-muted-foreground">FROM</label>
                            <DatePicker />
                        </div>
                        <div>
                            <label className="text-xs text-muted-foreground">TO</label>
                            <DatePicker />
                        </div>
                         <div className="flex items-end gap-2 col-start-1">
                            <Button><Search className="mr-2 h-4 w-4"/> Search</Button>
                            <Button variant="secondary">Clear Filter</Button>
                        </div>
                    </div>
                </div>
            </CardHeader>
            <CardContent className="p-0">
                 <div className="overflow-x-auto">
                     <Table>
                        <TableHeader>
                            <TableRow>
                                <TableHead>INVOICE #</TableHead>
                                <TableHead>INVOICE DATE</TableHead>
                                <TableHead className="text-right">NET AMOUNT</TableHead>
                                <TableHead className="text-center">ACTION</TableHead>
                            </TableRow>
                        </TableHeader>
                        <TableBody>
                        {invoices.length === 0 ? (
                            <TableRow>
                                <TableCell colSpan={4} className="h-24 text-center">No invoices found.</TableCell>
                            </TableRow>
                        ) : invoices.map((invoice) => (
                            <TableRow key={invoice.id}>
                                <TableCell className="font-medium text-primary">{invoice.invoiceNumber}</TableCell>
                                <TableCell>{invoice.date}</TableCell>
                                <TableCell className="text-right">{invoice.amount.toFixed(2)}</TableCell>
                                <TableCell className="text-center">
                                    <DropdownMenu>
                                        <DropdownMenuTrigger asChild>
                                            <Button variant="ghost" size="icon" className="h-8 w-8">
                                                <MoreVertical className="h-4 w-4" />
                                            </Button>
                                        </DropdownMenuTrigger>
                                        <DropdownMenuContent align="end">
                                            <DropdownMenuItem asChild>
                                                <Link href={`/tax-invoices/${invoice.invoiceNumber}`}>View Detail</Link>
                                            </DropdownMenuItem>
                                            <DropdownMenuItem>Download PDF</DropdownMenuItem>
                                        </DropdownMenuContent>
                                    </DropdownMenu>
                                </TableCell>
                            </TableRow>
                        ))}
                        </TableBody>
                    </Table>
                </div>
            </CardContent>
            <CardFooter className="flex-col items-start gap-4 sm:flex-row sm:items-center sm:justify-between pt-4 border-t">
                <p className="text-sm text-muted-foreground">Showing 1 to {invoices.length} of {invoices.length} entries</p>
                <div className="flex items-center gap-2">
                    <span>Page</span>
                    <Select defaultValue="1">
                        <SelectTrigger className="w-16"><SelectValue /></SelectTrigger>
                        <SelectContent>
                            <SelectItem value="1">1</SelectItem>
                        </SelectContent>
                    </Select>
                    <span className="text-sm">of 1</span>
                    <Button variant="outline" size="sm" disabled={invoices.length === 0}>Previous</Button>
                    <Button variant="outline" size="sm" disabled={invoices.length === 0}>Next</Button>
                </div>
            </CardFooter>
          </Card>
        </div>
      </DashboardLayout>
    </SidebarProvider>
  );
}
