
'use client';

import { useState } from 'react';
import { SidebarProvider } from '@/components/ui/sidebar';
import { DashboardLayout } from '@/components/dashboard-layout';
import type { BookingResult } from '@/lib/types';
import { Card, CardContent, CardDescription, CardHeader, CardTitle, CardFooter } from '@/components/ui/card';
import { Button } from '@/components/ui/button';
import { DollarSign, Download, History, PlusCircle } from 'lucide-react';
import { Table, TableBody, TableCell, TableHead, TableHeader, TableRow } from '@/components/ui/table';
import { Badge } from '@/components/ui/badge';

export default function WalletPage() {
  const [bookingResult, setBookingResult] = useState<BookingResult>(null);

  const handleBookingComplete = (result: BookingResult) => {
    if (result) {
      setBookingResult(result);
    }
  };
  
  const payouts = [
    { id: 'PAY-1729', date: '2024-07-20', amount: 1250.75, status: 'Paid' },
    { id: 'PAY-1728', date: '2024-07-13', amount: 980.50, status: 'Paid' },
    { id: 'PAY-1725', date: '2024-07-06', amount: 1500.00, status: 'Paid' },
  ];

  return (
    <SidebarProvider>
      <DashboardLayout onBookingComplete={handleBookingComplete} userRole="seller">
        <div className="flex flex-col gap-8">
          
          
          <div className="grid gap-6 md:grid-cols-3">
             <Card>
                <CardHeader className="flex flex-row items-center justify-between pb-2">
                    <CardTitle className="text-sm font-medium">Available Balance</CardTitle>
                    <DollarSign className="h-4 w-4 text-muted-foreground" />
                </CardHeader>
                <CardContent>
                    <div className="text-2xl font-bold">$1,234.56</div>
                    <p className="text-xs text-muted-foreground">Ready for payout</p>
                </CardContent>
            </Card>
            <Card>
                <CardHeader className="flex flex-row items-center justify-between pb-2">
                    <CardTitle className="text-sm font-medium">Requested Amount</CardTitle>
                    <History className="h-4 w-4 text-muted-foreground" />
                </CardHeader>
                <CardContent>
                    <div className="text-2xl font-bold">$0.00</div>
                    <p className="text-xs text-muted-foreground">Currently being processed</p>
                </CardContent>
            </Card>
            <Card>
                <CardHeader className="flex flex-row items-center justify-between pb-2">
                    <CardTitle className="text-sm font-medium">Total Paid</CardTitle>
                    <Download className="h-4 w-4 text-muted-foreground" />
                </CardHeader>
                <CardContent>
                    <div className="text-2xl font-bold">$15,789.00</div>
                    <p className="text-xs text-muted-foreground">Lifetime payouts received</p>
                </CardContent>
            </Card>
          </div>
          
          <Card>
            <CardHeader className="flex flex-row items-center">
              <div className="grid gap-2">
                <CardTitle>Payout History</CardTitle>
                <CardDescription>
                  Your recent COD payout requests and their statuses.
                </CardDescription>
              </div>
              <Button size="sm" className="ml-auto gap-1">
                <PlusCircle className="h-4 w-4" />
                Request Payout
              </Button>
            </CardHeader>
            <CardContent>
                <Table>
                    <TableHeader>
                        <TableRow>
                            <TableHead>Request ID</TableHead>
                            <TableHead>Date</TableHead>
                            <TableHead>Status</TableHead>
                            <TableHead className="text-right">Amount</TableHead>
                        </TableRow>
                    </TableHeader>
                    <TableBody>
                      {payouts.map((payout) => (
                        <TableRow key={payout.id}>
                            <TableCell className="font-medium">{payout.id}</TableCell>
                            <TableCell>{payout.date}</TableCell>
                            <TableCell>
                                <Badge variant={payout.status === 'Paid' ? 'default' : 'secondary'}
                                  className={payout.status === 'Paid' ? 'bg-green-100 text-green-800' : ''}>
                                  {payout.status}
                                </Badge>
                            </TableCell>
                            <TableCell className="text-right">${payout.amount.toFixed(2)}</TableCell>
                        </TableRow>
                      ))}
                    </TableBody>
                </Table>
            </CardContent>
             <CardFooter className="justify-center border-t p-4">
                <Button variant="ghost" size="sm" className="w-full">View All Payouts</Button>
            </CardFooter>
          </Card>
        </div>
      </DashboardLayout>
    </SidebarProvider>
  );
}
