
'use client';

import { useState } from 'react';
import {
  Table,
  TableBody,
  TableCell,
  TableHead,
  TableHeader,
  TableRow,
} from '@/components/ui/table';
import { Card, CardContent, CardHeader, CardTitle, CardDescription, CardFooter } from '@/components/ui/card';
import { Button } from '@/components/ui/button';
import { MoreVertical, UserPlus, ChevronLeft, ChevronRight, Search } from 'lucide-react';
import type { Rider } from '@/lib/types';
import {
  DropdownMenu,
  DropdownMenuContent,
  DropdownMenuItem,
  DropdownMenuTrigger,
} from '@/components/ui/dropdown-menu';
import { Avatar, AvatarFallback, AvatarImage } from '@/components/ui/avatar';
import { mockRiders } from '@/lib/data';
import { Badge } from '../ui/badge';
import { Input } from '../ui/input';
// A dialog for adding/editing a rider would be needed here.
// For now, the functionality is mocked.

export function RidersTable() {
  const [riders, setRiders] = useState<Rider[]>(mockRiders);

  return (
    <Card>
      <CardHeader className="flex flex-col md:flex-row md:items-center gap-4">
        <div className="grid gap-2 flex-1">
          <CardTitle>Riders</CardTitle>
          <CardDescription>Manage your riders and their assigned zones.</CardDescription>
        </div>
        <div className="flex items-center gap-2">
            <div className="relative">
                <Search className="absolute left-3 top-1/2 -translate-y-1/2 h-4 w-4 text-muted-foreground" />
                <Input placeholder="Search riders..." className="pl-9" />
            </div>
            <Button size="sm" className="gap-1">
                <UserPlus className="h-4 w-4" />
                Add Rider
            </Button>
        </div>
      </CardHeader>
      <CardContent className="p-0">
        <div className="overflow-x-auto">
          <Table>
            <TableHeader>
              <TableRow>
                <TableHead>Rider</TableHead>
                <TableHead>Zone</TableHead>
                <TableHead className="text-right">Actions</TableHead>
              </TableRow>
            </TableHeader>
            <TableBody>
              {riders.length === 0 ? (
                <TableRow>
                  <TableCell colSpan={3} className="h-24 text-center">
                    No riders found.
                  </TableCell>
                </TableRow>
              ) : riders.map(rider => (
                <TableRow key={rider.id}>
                  <TableCell>
                    <div className="flex items-center gap-3">
                        <Avatar className="h-10 w-10">
                            <AvatarImage src={rider.avatar} alt={rider.name} />
                            <AvatarFallback>{rider.name.charAt(0)}</AvatarFallback>
                        </Avatar>
                        <div>
                            <div className="font-medium">{rider.name}</div>
                            <div className="text-sm text-muted-foreground">{rider.phone}</div>
                        </div>
                    </div>
                  </TableCell>
                  <TableCell>
                    <Badge variant="secondary">Zone {rider.zone}</Badge>
                  </TableCell>
                  <TableCell className="text-right">
                    <DropdownMenu>
                      <DropdownMenuTrigger asChild>
                        <Button variant="ghost" size="icon" className="h-8 w-8">
                          <MoreVertical className="h-4 w-4" />
                          <span className="sr-only">More actions</span>
                        </Button>
                      </DropdownMenuTrigger>
                      <DropdownMenuContent align="end">
                        <DropdownMenuItem>View Profile</DropdownMenuItem>
                        <DropdownMenuItem>Assign Parcels</DropdownMenuItem>
                        <DropdownMenuItem>Edit</DropdownMenuItem>
                        <DropdownMenuItem className="text-red-500">Delete</DropdownMenuItem>
                      </DropdownMenuContent>
                    </DropdownMenu>
                  </TableCell>
                </TableRow>
              ))}
            </TableBody>
          </Table>
        </div>
      </CardContent>
       <CardFooter className="flex items-center justify-between border-t pt-4">
        <span className="text-sm text-muted-foreground">
            Showing 1-10 of {riders.length} riders
        </span>
        <div className="flex gap-2">
            <Button variant="outline" size="sm"><ChevronLeft className="h-4 w-4" /> Previous</Button>
            <Button variant="outline" size="sm">Next <ChevronRight className="h-4 w-4" /></Button>
        </div>
      </CardFooter>
    </Card>
  );
}
