
'use client';

import {
  Dialog,
  DialogContent,
  DialogHeader,
  DialogTitle,
  DialogFooter,
} from '@/components/ui/dialog';
import { Button } from '@/components/ui/button';

interface AnnouncementDialogProps {
  open: boolean;
  onClose: () => void;
}

export function AnnouncementDialog({ open, onClose }: AnnouncementDialogProps) {
  return (
    <Dialog open={open} onOpenChange={onClose}>
      <DialogContent className="sm:max-w-2xl">
        <DialogHeader>
          <DialogTitle className="text-2xl text-center font-bold">
            Welcome to Al-wasi Soft Tech
          </DialogTitle>
        </DialogHeader>
        <div className="py-4 text-sm text-left space-y-4">
          <p className="font-semibold">Dear Valued Customer,</p>
          <p className="font-bold">Important Update</p>
          <p>
            Due to the recent floods in KPK and Punjab, our delivery operations
            may be impacted. We are working diligently with available resources
            to minimize disruptions and deliver your shipments.
          </p>
          <p>
            However, some delays are anticipated. We appreciate your
            understanding and patience.
          </p>
          <p>
            Let's stay connected and pray for Pakistan's safety during this
            challenging time.
          </p>
          <p>Sincerely,</p>
          <p className="font-semibold">Al-wasi Soft Tech ECOM Solutions</p>
        </div>
        <DialogFooter className="justify-center">
          <Button onClick={onClose} variant="accent">
            Continue to Dashboard
          </Button>
        </DialogFooter>
      </DialogContent>
    </Dialog>
  );
}
