
import {
  Table,
  TableBody,
  TableCell,
  TableHead,
  TableHeader,
  TableRow,
} from '@/components/ui/table';
import { Card, CardContent, CardHeader, CardTitle, CardDescription } from '@/components/ui/card';
import { Badge } from '@/components/ui/badge';
import type { Complaint } from '@/lib/types';
import { format } from 'date-fns';

const statusStyles: Record<string, string> = {
  Open: 'bg-blue-100 text-blue-800 dark:bg-blue-900/50 dark:text-blue-300',
  'In Progress': 'bg-yellow-100 text-yellow-800 dark:bg-yellow-900/50 dark:text-yellow-300',
  Resolved: 'bg-green-100 text-green-800 dark:bg-green-900/50 dark:text-green-300',
  Closed: 'bg-gray-100 text-gray-800 dark:bg-gray-900/50 dark:text-gray-300',
};

export function ComplaintsTable({ 
    complaints,
 }: { 
    complaints: Complaint[],
 }) {
  return (
    <Card>
      <CardHeader className="flex flex-row items-center">
        <div className="grid gap-2">
            <CardTitle>Support Tickets</CardTitle>
            <CardDescription>A list of all your submitted complaints.</CardDescription>
        </div>
      </CardHeader>
      <CardContent className="p-0">
        <div className="overflow-x-auto">
            <Table>
                <TableHeader>
                <TableRow>
                    <TableHead>Ticket ID</TableHead>
                    <TableHead>Parcel ID</TableHead>
                    <TableHead>Subject</TableHead>
                    <TableHead>Status</TableHead>
                    <TableHead>Date</TableHead>
                </TableRow>
                </TableHeader>
                <TableBody>
                {complaints.length === 0 ? (
                    <TableRow>
                    <TableCell colSpan={5} className="h-24 text-center">
                        No complaints found.
                    </TableCell>
                    </TableRow>
                ) : complaints.map(complaint => (
                    <TableRow key={complaint.id}>
                    <TableCell className="font-medium">{complaint.id}</TableCell>
                    <TableCell>{complaint.parcelId}</TableCell>
                    <TableCell>{complaint.subject}</TableCell>
                    <TableCell>
                        <Badge variant="outline" className={`font-semibold ${statusStyles[complaint.status]}`}>{complaint.status}</Badge>
                    </TableCell>
                    <TableCell>{format(new Date(complaint.date), 'dd MMM, yyyy')}</TableCell>
                    </TableRow>
                ))}
                </TableBody>
            </Table>
        </div>
      </CardContent>
    </Card>
  );
}
