

import type { ReactNode } from 'react';
import { Sidebar } from '@/components/ui/sidebar';
import { SidebarNav } from '@/components/sidebar-nav';
import { Header } from '@/components/header';
import { mockAdmin, mockFinanceUser, mockUser, mockBranchOperator, mockMarketingUser, mockSupportUser, mockRiderManager, mockHRUser } from '@/lib/data';
import type { BookingResult, UserRole, ParcelFormValues } from '@/lib/types';
import { SwiftSendLogo } from './icons';
import Link from 'next/link';

export function DashboardLayout({
  children,
  onBookingComplete,
  bookParcelAction,
  userRole = 'seller',
  showChildren = true,
}: {
  children: ReactNode;
  onBookingComplete: (result: BookingResult) => void;
  bookParcelAction?: (values: ParcelFormValues) => Promise<BookingResult>;
  userRole?: UserRole;
  showChildren?: boolean;
}) {
  const getUser = () => {
    switch (userRole) {
        case 'super-admin':
            return mockAdmin;
        case 'finance':
            return mockFinanceUser;
        case 'branch-operator':
            return mockBranchOperator;
        case 'marketing-manager':
            return mockMarketingUser;
        case 'support':
            return mockSupportUser;
        case 'rider-manager':
            return mockRiderManager;
        case 'hr':
            return mockHRUser;
        default:
            return mockUser;
    }
  }
  
  const displayUser = getUser();

  return (
    <div className="grid min-h-screen w-full lg:grid-cols-[auto_1fr]">
        <Sidebar className="hidden border-r lg:block">
            <div className="flex h-full max-h-screen flex-col">
                <div className="flex h-16 items-center border-b px-4 lg:px-6">
                    <Link href={displayUser.role === 'seller' ? "/dashboard" : "/admin"} className="flex items-center gap-2 font-semibold">
                        <SwiftSendLogo className="h-7 w-7 text-primary" />
                        <span className="text-xl tracking-wider font-bold">Al-wasi Soft Tech</span>
                    </Link>
                </div>
                <div className="flex-1">
                    <SidebarNav user={displayUser} />
                </div>
            </div>
        </Sidebar>
        <div className="flex flex-col">
          <Header user={displayUser} onBookingComplete={onBookingComplete} bookParcelAction={bookParcelAction} />
          <main className="flex-1 p-4 sm:p-6 bg-muted/40">
            {showChildren && children}
          </main>
        </div>
    </div>
  );
}
