'use client';

import {
  AlertDialog,
  AlertDialogAction,
  AlertDialogContent,
  AlertDialogDescription,
  AlertDialogFooter,
  AlertDialogHeader,
  AlertDialogTitle,
} from '@/components/ui/alert-dialog';
import { Badge } from '@/components/ui/badge';
import type { BookingResult } from '@/lib/types';
import { format } from 'date-fns';
import { CheckCircle, Clock, Percent, Bot } from 'lucide-react';

interface ETAPredictionDialogProps {
  result: BookingResult;
  open: boolean;
  onOpenChange: (open: boolean) => void;
}

export function ETAPredictionDialog({ result, open, onOpenChange }: ETAPredictionDialogProps) {
  if (!result) return null;

  const { parcel, eta } = result;
  
  const formattedDate =
    eta.estimatedDeliveryTime !== "N/A"
      ? format(new Date(eta.estimatedDeliveryTime), "eee, MMM d, yyyy 'at' h:mm a")
      : "N/A";

  return (
    <AlertDialog open={open} onOpenChange={onOpenChange}>
      <AlertDialogContent>
        <AlertDialogHeader>
          <AlertDialogTitle className="flex items-center gap-2 text-xl">
            <CheckCircle className="h-6 w-6 text-green-500" />
            Parcel Booked Successfully!
          </AlertDialogTitle>
          <AlertDialogDescription className="pt-2">
            Your parcel has been booked. Here is the AI-powered delivery estimate.
            <br />
            Parcel ID: <Badge variant="secondary" className="font-mono">{parcel.id}</Badge>
          </AlertDialogDescription>
        </AlertDialogHeader>

        <div className="space-y-4 py-4">
          <div className="rounded-lg border bg-card-foreground/5 p-4 space-y-4">
            <h3 className="flex items-center gap-2 font-semibold text-foreground">
              <Bot className="h-5 w-5 text-primary" />
              Delivery ETA Prediction
            </h3>
            <div className="grid grid-cols-2 gap-4">
              <div className="flex items-start gap-3">
                <Clock className="h-5 w-5 flex-shrink-0 text-muted-foreground mt-1" />
                <div>
                  <p className="text-sm text-muted-foreground">Est. Delivery</p>
                  <p className="font-semibold text-foreground">{formattedDate}</p>
                </div>
              </div>
              <div className="flex items-start gap-3">
                <Percent className="h-5 w-5 flex-shrink-0 text-muted-foreground mt-1" />
                <div>
                  <p className="text-sm text-muted-foreground">Confidence</p>
                  <p className="font-semibold text-foreground">{(eta.confidence * 100).toFixed(0)}%</p>
                </div>
              </div>
            </div>
            <div>
              <p className="text-sm text-muted-foreground">Reasoning</p>
              <p className="text-sm text-foreground">{eta.reasoning}</p>
            </div>
          </div>
        </div>

        <AlertDialogFooter>
          <AlertDialogAction onClick={() => onOpenChange(false)}>
            Done
          </AlertDialogAction>
        </AlertDialogFooter>
      </AlertDialogContent>
    </AlertDialog>
  );
}
