
'use client';

import Link from 'next/link';
import { SwiftSendLogo } from '@/components/icons';
import { Facebook, Instagram, Linkedin, Youtube, Send } from 'lucide-react';

export function Footer() {
  const socialLinks = [
    { icon: Facebook, href: '#' },
    { icon: Instagram, href: '#' },
    { icon: Linkedin, href: '#' },
    { icon: Youtube, href: '#' },
    { icon: Send, href: '#' },
  ];

  const footerSections = [
    {
      title: 'Product',
      links: ['Features', 'Newsroom', 'Careers', 'FAQs'],
    },
    {
      title: 'Al-wasi Soft Tech COD',
      links: ['How it works', 'Solution', 'Features', 'Pricing'],
    },
    {
      title: 'Paid',
      links: ['Payment Method', 'Plugins', 'Features', 'Pricing'],
    },
  ];

  return (
    <footer className="bg-gray-900 text-white">
      <div className="container mx-auto px-4 md:px-6 py-12">
        <div className="grid grid-cols-2 md:grid-cols-5 gap-8">
          <div className="col-span-2 md:col-span-1">
            <Link href="/" className="flex items-center gap-2 mb-4">
              <SwiftSendLogo className="h-8 w-8" />
              <span className="text-2xl font-bold">Al-wasi Soft Tech</span>
            </Link>
          </div>

          {footerSections.map((section) => (
            <div key={section.title}>
              <h4 className="font-semibold mb-4">{section.title}</h4>
              <ul className="space-y-2">
                {section.links.map((link) => (
                  <li key={link}>
                    <Link href="#" className="text-gray-400 hover:text-white">
                      {link}
                    </Link>
                  </li>
                ))}
              </ul>
            </div>
          ))}

          <div>
            <h4 className="font-semibold mb-4">Legal Terms & Conditions</h4>
            <p className="text-sm text-gray-400 mb-4">
              I confirm that I have read Al-wasi Soft Tech's{' '}
              <Link href="#" className="underline hover:text-white">
                Privacy Policy
              </Link>
              , and I agree to the use of my data in line therewith.
            </p>
            <div className="flex space-x-4">
              {socialLinks.map(({ icon: Icon, href }, index) => (
                <Link key={index} href={href} className="text-gray-400 hover:text-white">
                  <Icon className="h-6 w-6" />
                </Link>
              ))}
            </div>
          </div>
        </div>
        <div className="border-t border-gray-800 mt-12 pt-6 text-sm text-gray-400">
          <p>Privacy - ©{new Date().getFullYear()} Al-wasi Soft Tech</p>
        </div>
      </div>
    </footer>
  );
}
