
'use client';

import {
  Home,
  Wallet,
  LogOut,
  LineChart,
  MessageSquareWarning,
  Users,
  Truck,
  Settings,
  Waypoints,
  FileText,
  PlusCircle,
  Smartphone,
  Ban,
  ShieldCheck,
  FileSpreadsheet,
  UploadCloud,
  History,
  Receipt,
  WalletCards,
  FileStack,
  FileBox,
  Newspaper,
  BookCopy,
  ScanLine,
  Building,
  CandlestickChart,
  Megaphone,
  UserCheck,
  Banknote,
  FileSearch,
  BookMarked,
  UserPlus,
  Ticket,
  Clock,
  Map,
  Download,
  PackageCheck,
  Package,
  RefreshCcw,
  AlertTriangle,
  User,
  ShieldAlert,
  Upload,
  UserRoundCheck,
  PackageSearch,
  FileClock,
  CircleDollarSign,
  Briefcase,
  Layers,
  ClipboardCheck,
  BarChartBig,
  ArrowRightLeft,
  XCircle,
  ThumbsUp,
  ThumbsDown,
  Archive,
  ArchiveRestore,
  Hourglass,
  ClipboardList,
  DollarSign,
  Fingerprint,
  HandCoins,
  Shield,
  Target,
  FileKey,
  FolderKanban,
  GitBranch,
  CalendarCheck,
  Landmark,
  Scale,
  BookUser,
  Calculator,
  FileSignature,
  FileCog,
  GanttChartSquare,
  MessageSquare,
  ArrowUpRight,
  Phone,
  Mail,
  HelpCircle,
  MessagesSquare,
  Library,
  Star,
  Smile,
  Search as SearchIcon,
  FolderOpen,
  UserMinus,
  FileWarning,
  KeyRound,
  Rss,
  TrendingUp,
} from 'lucide-react';
import type { User as AppUser, Complaint } from '@/lib/types';
import Link from 'next/link';
import { Button } from '@/components/ui/button';
import { ScrollArea } from '@/components/ui/scroll-area';
import { usePathname } from 'next/navigation';
import { cn } from '@/lib/utils';
import { useSidebar } from '@/components/ui/sidebar';
import { mockComplaints, mockUser } from '@/lib/data';
import { Badge } from '@/components/ui/badge';
import React from 'react';
import { CollapsibleMenu } from './collapsible-menu';


const sellerMenuGroups = [
  {
    title: 'MANAGE ORDERS',
    items: [
      { href: '/create-order', label: 'Create Order', icon: PlusCircle },
      { href: '/cancel-order', label: 'Cancel Order', icon: Ban },
      { href: '/transit-orders', label: 'Transit Orders', icon: Truck },
      { href: '/under-verification', label: 'Under Verification', icon: ShieldCheck },
      { href: '/order-logs', label: 'Order Logs', icon: BookCopy },
      { href: '/airway-bills', label: 'Airway Bills', icon: FileText },
      { href: '/bulk-upload', label: 'Bulk Upload', icon: UploadCloud },
      { href: '/complaints', label: 'My Complaints', icon: MessageSquareWarning, id: 'my-complaints' },
    ]
  },
  {
    title: 'LOAD SHEET',
    items: [
      { href: '/generate-load-sheet', label: 'Generate Load Sheet', icon: FileSpreadsheet },
      { href: '/load-sheet-logs', label: 'Load Sheet Logs', icon: History },
    ]
  },
  {
    title: 'PAYMENTS',
    items: [
      { href: '/cash-payment-receipt', label: 'Cash Payment Receipt', icon: Receipt },
      { href: '/settlement-logs', label: 'Settlement Logs', icon: WalletCards },
      { href: '/tax-invoices', label: 'Tax Invoices', icon: FileStack },
    ]
  },
  {
    title: 'PACKAGING',
    items: [
      { href: '/new-request-packaging', label: 'New Request', icon: PlusCircle },
      { href: '/packaging-logs', label: 'Packaging Logs', icon: FileBox },
    ]
  },
  {
    title: 'REPORTS',
    items: [
      { href: '/monthly-weekly-order-wise', label: 'Monthly/Weekly Order Wise', icon: LineChart },
      { href: '/monthly-weekly-amount-wise', label: 'Monthly/Weekly Amount Wise', icon: LineChart },
      { href: '/order-status-report', label: 'Order Status Report', icon: LineChart },
      { href: '/instock-report', label: 'InStock Report', icon: LineChart },
      { href: '/pickup-report', label: 'Pickup Report', icon: LineChart },
      { href: '/destination-city-wise', label: 'Destination City Wise', icon: LineChart },
      { href: '/complaints', label: 'Complaint Details', icon: MessageSquareWarning },
    ]
  },
   {
    title: 'OTHERS',
    items: [
      { href: '/integrations', label: 'Integrations', icon: Waypoints },
      { href: '/mobile-app', label: 'Mobile App', icon: Smartphone },
      { href: '/company-news', label: 'Company News', icon: Newspaper },
    ]
  }
];

const financeMenuGroups = [
    {
        title: 'FINANCE & TAX',
        items: [
            { href: '/finance/dashboard', label: 'Dashboard', icon: Home },
            { 
                label: 'Cash & COD Management', 
                icon: Banknote,
                subItems: [
                    { href: '/finance/cod/collection', label: 'Daily Cash Collection' },
                    { href: '/finance/cod/deposits', label: 'Deposits to Bank' },
                    { href: '/finance/cod/pending', label: 'Pending COD Report' },
                    { href: '/finance/cod/discrepancy', label: 'COD Variance Report' },
                ]
            },
            { 
                label: 'Merchant Settlements', 
                icon: HandCoins,
                subItems: [
                    { href: '/finance/settlements/invoices', label: 'Invoices' },
                    { href: '/finance/settlements/payments', label: 'Payments to Merchants' },
                    { href: '/finance/settlements/deductions', label: 'Deductions' },
                    { href: '/finance/settlements/pending-report', label: 'Pending Settlement Report' },
                    { href: '/finance/settlements/disputes', label: 'Dispute Management' },
                ]
            },
            { 
                label: 'Company Accounting', 
                icon: BookUser,
                subItems: [
                    { href: '/finance/accounting/chart-of-accounts', label: 'Chart of Accounts' },
                    { href: '/finance/accounting/journal-entries', label: 'Journal Entries' },
                    { href: '/finance/accounting/ledger', label: 'Ledger View' },
                    { href: '/finance/accounting/trial-balance', label: 'Trial Balance' },
                    { href: '/finance/accounting/balance-sheet', label: 'Balance Sheet' },
                    { href: '/finance/accounting/pnl-statement', label: 'Profit & Loss Statement' },
                ]
            },
             { 
                label: 'Expenses & Payments', 
                icon: Receipt,
                subItems: [
                    { href: '/finance/expenses/company', label: 'Company Expenses' },
                    { href: '/finance/expenses/branch', label: 'Branch Level Expenses' },
                    { href: '/finance/expenses/vendor', label: 'Vendor Payments' },
                    { href: '/finance/expenses/approval', label: 'Expense Approval Flow' },
                    { href: '/finance/expenses/recurring', label: 'Recurring Expenses' },
                ]
            },
             { 
                label: 'Payroll & Salaries', 
                icon: WalletCards,
                subItems: [
                    { href: '/finance/payroll/master-data', label: 'Employee Master Data' },
                    { href: '/finance/payroll/attendance', label: 'Attendance & Overtime' },
                    { href: '/finance/payroll/run', label: 'Payroll Run' },
                    { href: '/finance/payroll/tax', label: 'Tax Deductions' },
                    { href: '/finance/payroll/slips', label: 'Salary Slips' },
                    { href: '/finance/payroll/bonus', label: 'Bonus & Incentives' },
                ]
            },
             { 
                label: 'Taxation & Compliance', 
                icon: Calculator,
                subItems: [
                    { href: '/finance/tax/gst-vat', label: 'GST Calculation' },
                    { href: '/finance/tax/withholding', label: 'Income Tax Withholding' },
                    { href: '/finance/tax/filings', label: 'Tax Filings' },
                    { href: '/finance/tax/efiling', label: 'e-Filing Integration' },
                    { href: '/finance/tax/deduction-reports', label: 'Tax Deduction Reports' },
                    { href: '/finance/tax/calendar', label: 'Tax Calendar Alerts' },
                ]
            },
             { 
                label: 'Banking & Reconciliation', 
                icon: Landmark,
                subItems: [
                    { href: '/finance/banking/accounts', label: 'Bank Accounts Linked' },
                    { href: '/finance/banking/reconciliation', label: 'Bank Reconciliation' },
                    { href: '/finance/banking/cheques', label: 'Cheque Management' },
                    { href: '/finance/banking/discrepancy-alerts', label: 'Discrepancy Alerts' },
                ]
            },
            { 
                label: 'Vouchers & Manual Entry', 
                icon: FileSignature,
                subItems: [
                    { href: '/finance/vouchers/cash-payment', label: 'Cash Payment Voucher' },
                    { href: '/finance/vouchers/bank-payment', label: 'Bank Payment Voucher' },
                    { href: '/finance/vouchers/cash-receipt', label: 'Cash Receipt Voucher' },
                    { href: '/finance/vouchers/bank-receipt', label: 'Bank Receipt Voucher' },
                    { href: '/finance/vouchers/journal', label: 'Journal Voucher' },
                    { href: '/finance/vouchers/contra', label: 'Contra Voucher' },
                ]
            },
            { 
                label: 'Audit & Controls', 
                icon: ShieldCheck,
                subItems: [
                    { href: '/finance/audit/roles', label: 'Role Based Access' },
                    { href: '/finance/audit/approvals', label: 'Approval Flow' },
                    { href: '/finance/audit/logs', label: 'Audit Logs' },
                    { href: '/finance/audit/alerts', label: 'System Alerts' },
                ]
            },
            { 
                label: 'Reports & Analytics', 
                icon: LineChart,
                subItems: [
                    { href: '/finance/reports/daily-cod', label: 'Daily COD Report' },
                    { href: '/finance/reports/merchant-settlement', label: 'Merchant Settlement' },
                    { href: '/finance/reports/bank-reconciliation', label: 'Bank Reconciliation' },
                    { href: '/finance/reports/cash-flow', label: 'Daily Cash Flow Report' },
                    { href: '/finance/reports/cod-deposit', label: 'COD vs Deposit Report' },
                    { href: '/finance/reports/settlement-aging', label: 'Settlement Aging Report' },
                    { href: '/finance/reports/expense-budget', label: 'Expense vs Budget Report' },
                    { href: '/finance/reports/payroll-cost', label: 'Payroll Cost Analysis' },
                    { href: '/finance/reports/branch-profitability', label: 'Branch Profitability' },
                    { href: '/finance/reports/tax', label: 'Tax Reports' },
                    { href: '/finance/reports/financial-statements', label: 'Financial Statements' },
                ]
            },
        ]
    }
];

const branchMenuGroups = [
    {
        title: 'OVERVIEW',
        items: [
            { href: '/admin/branch/dashboard', label: 'Dashboard', icon: Home },
        ]
    },
    {
        title: 'Shipments & Operations',
        items: [
            { href: '/admin/branch/bagging', label: 'Bagging', icon: Archive },
            { href: '/admin/branch/unbagging', label: 'Unbagging', icon: ArchiveRestore },
            { href: '/admin/branch/pickup', label: 'Pickup Orders', icon: PackageCheck},
            { href: '/admin/branch/scanning', label: 'Receive Shipments', icon: ScanLine },
            { href: '/admin/branch/dispatch', label: 'Dispatch Shipments', icon: Upload },
            { href: '/admin/branch/carrier-manifest', label: 'Carrier Manifest', icon: GanttChartSquare },
            { href: '/admin/branch/assigned-deliveries', label: 'Deliveries Assigned', icon: UserRoundCheck},
            { href: '/admin/branch/delivery-success', label: 'Successful Deliveries', icon: ThumbsUp},
            { href: '/admin/branch/delivery-failed', label: 'Failed Deliveries', icon: ThumbsDown},
            { href: '/admin/branch/attempts', label: 'Reattempt Shipment', icon: ClipboardCheck },
            { href: '/admin/branch/returns', label: 'Return Shipments (RTO)', icon: RefreshCcw},
            { href: '/admin/branch/forward-to-origin', label: 'Forward to Origin / Hub', icon: ArrowRightLeft},
            { href: '/admin/branch/tracking', label: 'Shipment Tracking', icon: PackageSearch },
            { href: '/admin/branch/shipment-bag-id', label: 'Search Bag', icon: Fingerprint },
            { href: '/admin/branch/lost-hold', label: 'Lost / Hold', icon: AlertTriangle },
        ]
    },
    {
        title: 'Rider Management',
        items: [
            { href: '/admin/branch/rider-management', label: 'Onboarding', icon: UserPlus },
            { href: '/admin/branch/rider-daily-load', label: 'Rider Daily Load', icon: ClipboardList },
            { href: '/admin/branch/cod-value-assigned', label: 'COD Value Assigned', icon: DollarSign },
        ]
    },
    {
        title: 'Staff Management',
        items: [
            { href: '/admin/branch/staff-management', label: 'Manage Staff', icon: Users },
            { href: '/admin/branch/staff-salary', label: 'Staff Salary', icon: HandCoins },
            { href: '/admin/branch/staff-attendance', label: 'Attendance', icon: Clock },
        ]
    },
     {
        title: 'Finance & Cash Flow',
        items: [
            { href: '/admin/branch/finance', label: 'Rider Handover', icon: WalletCards },
            { href: '/admin/branch/finance/pending-cod', label: 'Pending COD', icon: Hourglass },
            { href: '/admin/branch/finance/variance', label: 'Variance Report', icon: BarChartBig },
        ]
    },
    {
        title: 'Cashier Module',
        items: [
             { href: '/admin/branch/cashier/collection', label: 'Collect COD', icon: CircleDollarSign },
             { href: '/admin/branch/cashier/deposit', label: 'Mark Deposited', icon: Banknote },
             { href: '/admin/branch/cashier/tracking', label: 'Cash in Transit', icon: Layers },
        ]
    },
     {
        title: 'Complaints & Support',
        items: [
            { href: '/admin/branch/complaints', label: 'Register Complaint', icon: MessageSquareWarning },
        ]
    },
     {
        title: 'Reports & Analytics',
        items: [
            { href: '/admin/branch/reports', label: 'Shipment Reports', icon: LineChart },
        ]
    },
     {
        title: 'System & Security',
        items: [
            { href: '/admin/branch/sync', label: 'Sync Status', icon: History },
            { href: '/admin/branch/audit-trail', label: 'Audit Trail', icon: FileClock },
            { href: '/admin/branch/activity', label: 'Activity Log', icon: History },
        ]
    },
];

const marketingMenuGroups = [
  {
    title: 'Main',
    items: [
      { href: '/admin/marketing/dashboard', label: 'Dashboard', icon: Home },
      { href: '/admin/marketing/alerts', label: 'Alerts', icon: ShieldAlert },
    ],
  },
  {
    title: 'Merchant',
    items: [
      {
        label: 'Management',
        icon: Briefcase,
        subItems: [
          { href: '/admin/marketing/merchant/profiles', label: 'Profiles' },
          { href: '/admin/marketing/merchant/hierarchy', label: 'Hierarchy' },
          { href: '/admin/marketing/merchant/wallet', label: 'Wallet Status' },
          { href: '/admin/marketing/merchant/shipments', label: 'Shipment Summary' },
        ],
      },
      {
        label: 'Rates & Documents',
        icon: FileKey,
        subItems: [
          { href: '/admin/marketing/merchant/special-rates', label: 'Special Rates' },
          { href: '/admin/marketing/merchant/documents', label: 'Documents' },
        ],
      },
    ],
  },
  {
    title: 'Support',
    items: [
      {
        label: 'Complaints',
        icon: MessageSquareWarning,
        subItems: [
          { href: '/admin/marketing/complaints/new', label: 'New Complaint' },
          { href: '/admin/marketing/complaints/tracker', label: 'Complaint Tracker' },
          { href: '/admin/marketing/complaints/escalations', label: 'Escalation Matrix' },
        ],
      },
       {
        label: 'Tools',
        icon: UserCheck,
        subItems: [
          { href: '/admin/marketing/support/communication-log', label: 'Communication Log' },
          { href: '/admin/marketing/support/task-manager', label: 'Task Manager' },
          { href: '/admin/marketing/support/sentiment-tracking', label: 'Sentiment Tracking' },
          { href: '/admin/marketing/support/live-chat', label: 'Live Chat' },
        ],
      },
    ],
  },
  {
    title: 'Finance',
    items: [
      { href: '/admin/marketing/finance/cod-status', label: 'COD Status', icon: CircleDollarSign },
      { href: '/admin/marketing/invoices', label: 'Invoice Panel', icon: FileText },
      { href: '/admin/marketing/finance/disputes', label: 'Finance Disputes', icon: ShieldAlert },
    ],
  },
  {
    title: 'Sales',
    items: [
      { href: '/admin/marketing/sales/lead-management', label: 'Lead Management', icon: Users },
      { href: '/admin/marketing/sales/territory-mapping', label: 'Territory Mapping', icon: Map },
      { href: '/admin/marketing/sales/targets', label: 'Target vs Achievement', icon: Target },
      { href: '/admin/marketing/sales/pipeline', label: 'Pipeline Tracker', icon: FolderKanban },
      { href: '/admin/marketing/sales/lost-leads', label: 'Lost Lead Analysis', icon: UserCheck },
    ],
  },
  {
    title: 'Performance',
    items: [
      { href: '/admin/marketing/performance/merchant-ranking', label: 'Merchant Ranking', icon: CandlestickChart },
      { href: '/admin/marketing/performance/team-ranking', label: 'Sales Team Ranking', icon: Users },
      { href: '/admin/marketing/performance/heatmap', label: 'Regional Heatmap', icon: Map },
      { href: '/admin/marketing/performance/churn-analysis', label: 'Churn Analysis', icon: LineChart },
    ],
  },
  {
    title: 'Reports',
    items: [
        { label: 'Reports', icon: LineChart, subItems: [
                { href: '/admin/marketing/reports/settlement', label: 'Merchant Settlement' },
                { href: '/admin/marketing/reports/complaint-sla', label: 'Complaint SLA Breach' },
                { href: '/admin/marketing/reports/regional-performance', label: 'Regional Performance' },
                { href: '/admin/marketing/reports/retention-churn', label: 'Retention & Churn' },
                { href: '/admin/marketing/reports/return-rto', label: 'Return & RTO' },
                { href: '/admin/marketing/reports/rate-card', label: 'Rate Card Report' },
            ]
        }
    ],
  },
  {
    title: 'Contracts & Legal',
    items: [
      { href: '/admin/marketing/contracts/vault', label: 'Contract Vault', icon: FileKey },
      { href: '/admin/marketing/contracts/expiry-alerts', label: 'Expiry Alerts', icon: ShieldAlert },
      { href: '/admin/marketing/contracts/rate-changes', label: 'Rate Change Requests', icon: FileText },
      { href: '/admin/marketing/contracts/digital-signatures', label: 'Digital Signatures', icon: FileSignature },
    ],
  },
  {
    title: 'Staff & System',
    items: [
       { href: '/admin/marketing/staff/payouts', label: 'Staff Payouts', icon: WalletCards },
       { href: '/admin/marketing/staff/attendance', label: 'Staff Attendance', icon: CalendarCheck },
       { href: '/admin/marketing/system/audit-log', label: 'Audit Log', icon: FileClock },
       { href: '/admin/marketing/system/roles', label: 'Role-based Access', icon: Shield },
    ]
  }
];

const riderManagerMenuGroups = [
    {
        title: 'OPERATIONS',
        items: [
            { href: '/admin/rider-manager/dashboard', label: 'Dashboard', icon: Home },
            { 
                label: 'Rider Management', 
                icon: User,
                subItems: [
                    { href: '/admin/rider-manager/riders', label: 'Rider Profiles' },
                    { href: '/admin/rider-manager/attendance', label: 'Attendance / Shift Logs' },
                    { href: '/admin/rider-manager/tracking', label: 'Live GPS Tracking' },
                ]
            },
            { 
                label: 'Delivery Operations', 
                icon: Truck,
                subItems: [
                    { href: '/admin/rider-manager/assign', label: 'Assign Parcels' },
                ]
            },
             { 
                label: 'Performance & Reports', 
                icon: LineChart,
                subItems: [
                    { href: '/admin/rider-manager/reports/efficiency', label: 'Rider Efficiency' },
                    { href: '/admin/rider-manager/reports/handover', label: 'Daily Handover' },
                    { href: '/admin/rider-manager/reports/complaint-ratio', label: 'Complaint Ratio' },
                    { href: '/admin/rider-manager/reports/top-riders', label: 'Top Riders' },
                    { href: '/admin/rider-manager/reports/weak-riders', label: 'Weak Riders' },
                ]
            },
             { 
                label: 'Finance Link (COD)', 
                icon: Wallet,
                subItems: [
                    { href: '/admin/rider-manager/finance/collection-log', label: 'Rider Cash Collection' },
                    { href: '/admin/rider-manager/finance/pending-cod', label: 'Pending COD Submission' },
                    { href: '/admin/rider-manager/finance/discrepancy', label: 'Discrepancy Report' },
                ]
            },
             { 
                label: 'Complaints & Escalations', 
                icon: MessageSquareWarning,
                subItems: [
                    { href: '/admin/rider-manager/complaints/related', label: 'Rider Related Complaints' },
                    { href: '/admin/rider-manager/complaints/history', label: 'Action History' },
                    { href: '/admin/rider-manager/complaints/feedback', label: 'Customer Feedback' },
                ]
            },
        ]
    }
];

const supportMenuGroups = [
    {
        title: 'SUPPORT',
        items: [
            { href: '/admin/support/dashboard', label: 'Dashboard', icon: Home },
            { 
                label: 'Tickets', 
                icon: Ticket,
                subItems: [
                    { href: '/admin/support/tickets/new', label: 'New Complaint' },
                    { href: '/admin/support/tickets/in-progress', label: 'In-Progress' },
                    { href: '/admin/support/tickets/resolved', label: 'Resolved' },
                    { href: '/admin/support/tickets/escalated', label: 'Escalated' },
                    { href: '/admin/support/tickets/auto-closure', label: 'Auto-Closure Rules' },
                ]
            },
            { 
                label: 'Interaction Logs', 
                icon: BookCopy,
                subItems: [
                    { href: '/admin/support/interaction-logs/call-log', label: 'Call Log' },
                    { href: '/admin/support/interaction-logs/chat-log', label: 'Chat Log' },
                    { href: '/admin/support/interaction-logs/email-log', label: 'Email Log' },
                ]
            },
             { 
                label: 'Knowledge Base', 
                icon: HelpCircle,
                subItems: [
                    { href: '/admin/support/knowledge-base/faq', label: 'FAQ' },
                    { href: '/admin/support/knowledge-base/quick-replies', label: 'Quick Replies' },
                    { href: '/admin/support/knowledge-base/sop-library', label: 'SOP Library' },
                ]
            },
            { href: '/admin/support/tracking', label: 'Customer Tracking', icon: FileSearch },
            { 
                label: 'Reports & Analytics', 
                icon: LineChart,
                subItems: [
                    { href: '/admin/support/reports/daily-ticket', label: 'Daily Ticket Report' },
                    { href: '/admin/support/reports/sla-breach', label: 'SLA Breach Report' },
                    { href: '/admin/support/reports/trend', label: 'Complaint Trend' },
                    { href: '/admin/support/reports/top-merchants', label: 'Top Merchants by Complaint' },
                    { href: '/admin/support/reports/root-cause', label: 'Root Cause Analysis' },
                    { href: '/admin/support/reports/agent-performance', label: 'Agent Performance' },
                ]
            },
            { 
                label: 'Quality & Feedback', 
                icon: Star,
                subItems: [
                    { href: '/admin/support/quality/feedback', label: 'Post-Resolution Feedback' },
                    { href: '/admin/support/quality/nps', label: 'NPS Dashboard' },
                    { href: '/admin/support/quality/review', label: 'Quality Team Review' },
                ]
            },
             { 
                label: 'System & Security', 
                icon: Shield,
                subItems: [
                    { href: '/admin/support/system/roles', label: 'Role-Based Access' },
                    { href: '/admin/support/system/audit-trail', label: 'Audit Trail' },
                ]
            },
        ]
    }
];

const hrMenuGroups = [
    {
        title: 'Main',
        items: [
            { href: '/admin/hr/dashboard', label: 'Dashboard', icon: Home },
        ],
    },
    {
        title: 'Core HR',
        items: [
            { href: '/admin/hr/directory', label: 'Employee Directory', icon: Users },
            { href: '/admin/hr/recruitment', label: 'Recruitment', icon: UserPlus },
            { href: '/admin/hr/attendance', label: 'Attendance & Leaves', icon: CalendarCheck },
            { href: '/admin/hr/exit', label: 'Exit & Handover', icon: UserMinus },
        ],
    },
    {
        title: 'Compensation',
        items: [
            { href: '/admin/hr/payroll', label: 'Payroll', icon: WalletCards },
            { href: '/admin/hr/performance', label: 'Performance & KPIs', icon: TrendingUp },
        ],
    },
    {
        title: 'Development',
        items: [
            { href: '/admin/hr/training', label: 'Training & Documents', icon: FolderOpen },
        ],
    },
];

const superAdminMenuGroups = [
    {
        title: 'OVERVIEW',
        items: [
            { href: '/admin', label: 'Dashboard', icon: Home },
            { href: '/admin/shipments', label: 'Shipments', icon: Truck },
        ]
    },
    {
        title: 'MERCHANTS',
        items: [
            { href: '/admin/merchants', label: 'Merchants', icon: Users },
        ]
    },
    {
        title: 'FINANCE, TAX & ACCOUNTING',
        items: financeMenuGroups[0].items,
    },
    {
        title: 'MARKETING & SALES',
        items: marketingMenuGroups.flatMap(g => g.items),
    },
    {
        title: 'SUPPORT & COMPLAINTS',
        items: supportMenuGroups[0].items,
    },
    {
        title: 'RIDER OPS',
        items: riderManagerMenuGroups[0].items,
    },
    {
        title: 'HR & EMPLOYEES',
        items: hrMenuGroups.flatMap(g => g.items),
    },
    {
        title: 'BRANCH OPERATIONS',
        items: branchMenuGroups.flatMap(g => g.items.filter(item => item.href !== '/admin/branch/dashboard')),
    },
    {
        title: 'LOGISTICS & OPS',
        items: [
            { href: '/admin/logistics/bagging', label: 'Bagging & Manifest', icon: Archive},
            { href: '/admin/logistics/dispatch', label: 'Vehicle Dispatch', icon: Truck},
            { href: '/admin/logistics/shortage', label: 'Shortage/Loss Reports', icon: FileWarning},
            { href: '/admin/logistics/returns', label: 'Return Shipments', icon: RefreshCcw},
            { href: '/admin/logistics/routing', label: 'Routing Efficiency', icon: Waypoints},
        ]
    },
    {
        title: 'COMPLIANCE & AUDIT',
        items: [
            { href: '/admin/audit/internal-logs', label: 'Internal Audit Logs', icon: FileClock},
            { href: '/admin/audit/fraud-detection', label: 'Fraud Detection', icon: ShieldAlert},
            { href: '/admin/audit/tax-compliance', label: 'Tax Compliance Status', icon: FileText},
            { href: '/admin/audit/error-reports', label: 'Branch Error Reports', icon: BarChartBig},
        ]
    },
    {
        title: 'System Settings & Control',
        items: [
            { href: '/admin/system/roles', label: 'User Roles & Permissions', icon: Users },
            { href: '/admin/system/integrations', label: 'Module Integrations', icon: Waypoints },
            { href: '/admin/system/security', label: 'Security & Backups', icon: ShieldCheck },
            { href: '/admin/system/api', label: 'API Access', icon: KeyRound },
            { href: '/admin/system/updates', label: 'Internal Updates', icon: Rss },
        ]
    }
];

export function SidebarNav({ user }: { user: AppUser }) {
  const pathname = usePathname();
  const { state: sidebarState } = useSidebar();
  
  const [complaints, setComplaints] = React.useState<Complaint[]>([]);

  React.useEffect(() => {
    const sellerComplaints = mockComplaints.filter(c => c.sellerId === mockUser.id);
    setComplaints(sellerComplaints);
  }, []);

  const openComplaintsCount = complaints.filter(c => c.status === 'Open' || c.status === 'In Progress').length;


  const handleLogout = () => {
    window.location.href = '/login';
  };
  
  const isExpanded = sidebarState === 'expanded';

  const getMenuGroups = () => {
    switch (user.role) {
        case 'super-admin':
        case 'admin':
            return superAdminMenuGroups;
        case 'finance':
        case 'finance-manager':
            return financeMenuGroups;
        case 'branch-operator':
            return branchMenuGroups;
        case 'marketing':
        case 'marketing-manager':
            return marketingMenuGroups;
        case 'rider-manager':
            return riderManagerMenuGroups;
        case 'support':
            return supportMenuGroups;
        case 'hr':
            return hrMenuGroups;
        default:
            return sellerMenuGroups;
    }
  }

  const menuGroups = getMenuGroups();
  
  const renderMenu = (groups: any[]) => (
     <>
        {groups.map((group) => (
          <div key={group.title} className="mb-1">
            <h3 className={cn("px-3 py-2 font-semibold text-primary uppercase text-xs tracking-wider", !isExpanded && "hidden")}>{group.title}</h3>
            <div className="flex flex-col gap-1">
              {group.items.map((item: any) => (
                 <CollapsibleMenu key={`${group.title}-${item.label}`} item={item} isExpanded={isExpanded} />
              ))}
            </div>
          </div>
        ))}
      </>
  );

  return (
    <div className="flex h-full max-h-screen flex-col">
        <ScrollArea className="flex-1">
            <nav className="grid items-start p-2 text-sm font-medium pb-12">
                {renderMenu(menuGroups)}
            </nav>
        </ScrollArea>
        <div className={cn("mt-auto p-2 border-t", !isExpanded && "p-1")}>
             <Button variant="ghost" className="w-full" onClick={handleLogout}>
              <LogOut className="h-5 w-5" />
              <span className={cn("ml-2", !isExpanded && "sr-only")}>Log out</span>
            </Button>
        </div>
    </div>
  );
}
