

import type { Parcel, Rider, User, Seller, Complaint, NewsItem, Branch } from '@/lib/types';
import { PlaceHolderImages } from '@/lib/placeholder-images';

const userAvatar = PlaceHolderImages.find(img => img.id === 'user-avatar-1');
const adminAvatar = PlaceHolderImages.find(img => img.id === 'admin-avatar-1');

export const mockUser: User = {
  id: 'user-1',
  name: 'Seller Name',
  companyName: 'Chic Boutique',
  email: 'catherine@chicboutique.com',
  avatar: userAvatar?.imageUrl ?? 'https/picsum.photos/seed/swiftsend-user1/100/100',
  role: 'seller',
};

export const mockAdmin: User = {
    id: 'admin-1',
    name: 'Super Admin',
    companyName: 'Al-wasi Soft Tech HQ',
    email: 'admin@alwasisofttech.com',
    avatar: adminAvatar?.imageUrl ?? 'https/picsum.photos/seed/alwasisofttech-admin1/100/100',
    role: 'super-admin',
}

export const mockFinanceUser: User = {
    id: 'finance-1',
    name: 'Finance User',
    companyName: 'Al-wasi Soft Tech HQ',
    email: 'finance@alwasisofttech.com',
    avatar: 'https/picsum.photos/seed/alwasisofttech-finance1/100/100',
    role: 'finance',
}

export const mockBranchOperator: User = {
    id: 'branch-op-1',
    name: 'Branch Multan',
    companyName: 'Branch Multan',
    email: 'branch.multan@alwasisofttech.com',
    avatar: 'https/picsum.photos/seed/user2/100/100',
    role: 'branch-operator',
};

export const mockMarketingUser: User = {
    id: 'marketing-1',
    name: 'Marketing Team',
    companyName: 'Al-wasi Soft Tech HQ',
    email: 'marketing@alwasisofttech.com',
    avatar: 'https/picsum.photos/seed/user3/100/100',
    role: 'marketing-manager',
};

export const mockSupportUser: User = {
    id: 'support-1',
    name: 'Support Team',
    companyName: 'Al-wasi Soft Tech HQ',
    email: 'support@alwasisofttech.com',
    avatar: 'https/picsum.photos/seed/user4/100/100',
    role: 'support',
};

export const mockRiderManager: User = {
    id: 'rider-manager-1',
    name: 'Rider Manager',
    companyName: 'Al-wasi Soft Tech HQ',
    email: 'ops@alwasisofttech.com',
    avatar: 'https/picsum.photos/seed/user5/100/100',
    role: 'rider-manager',
};

export const mockHRUser: User = {
    id: 'hr-1',
    name: 'HR Manager',
    companyName: 'Al-wasi Soft Tech HQ',
    email: 'hr@alwasisofttech.com',
    avatar: 'https/picsum.photos/seed/user6/100/100',
    role: 'hr',
};


export const mockMarketingTeam: User[] = [
    { id: 'mkt-1', name: 'Marketing Team Lead', companyName: 'Al-wasi Soft Tech HQ', email: 'lead@marketing.com', avatar: 'https://picsum.photos/seed/mkt1/100/100', role: 'marketing-manager' },
    { id: 'mkt-2', name: 'BDM Lahore', companyName: 'Al-wasi Soft Tech HQ', email: 'bdm.lahore@marketing.com', avatar: 'https://picsum.photos/seed/mkt2/100/100', role: 'marketing' },
];


export const mockSellers: Seller[] = [
    { id: 'user-1', name: 'Chic Boutique', companyName: 'Chic Boutique', email: 'catherine@chicboutique.com', avatar: 'https://picsum.photos/seed/seller1/100/100'},
    { id: 'user-2', name: 'Gadget World', companyName: 'Gadget World', email: 'store@gadgetworld.com', avatar: 'https://picsum.photos/seed/seller2/100/100'},
];

export const mockRiders: Rider[] = [
    { id: 'rider-1', name: 'Ali Khan', phone: '0300-1234567', zone: 'A', avatar: 'https://picsum.photos/seed/rider1/100/100' },
    { id: 'rider-2', name: 'Bilal Ahmed', phone: '0311-9876543', zone: 'B', avatar: 'https://picsum.photos/seed/rider2/100/100' },
    { id: 'rider-3', name: 'Faisal Jabbar', phone: '0333-5554433', zone: 'A', avatar: 'https://picsum.photos/seed/rider3/100/100' },
];

export const mockBranches: Branch[] = [
    { id: 'branch-1', name: 'Multan Main Branch', manager: 'Ahmed Hassan', location: 'Multan', totalShipments: 1254, avatar: 'https://picsum.photos/seed/branch1/100/100' },
    { id: 'branch-2', name: 'Lahore Hub', manager: 'Fatima Khan', location: 'Lahore', totalShipments: 3450, avatar: 'https://picsum.photos/seed/branch2/100/100' },
    { id: 'branch-3', name: 'Karachi Central', manager: 'Usman Ghani', location: 'Karachi', totalShipments: 2870, avatar: 'https://picsum.photos/seed/branch3/100/100' },
];

export const mockParcels: Parcel[] = [
  {
    id: 'PCL162818',
    recipientName: 'Ahmed Khan',
    address: 'House 123, Street 4, G-8/1',
    contact: '0333-5551234',
    codAmount: 1500,
    city: 'Anytown',
    zone: 'A',
    status: 'Delivered',
    bookingDate: new Date(Date.now() - 2 * 24 * 60 * 60 * 1000).toISOString(),
    sellerId: 'user-1',
    orderReferenceNumber: 'REF001'
  },
  {
    id: 'PCL162819',
    recipientName: 'Fatima Ali',
    address: 'Office 404, 4th Floor, Business Tower, Blue Area',
    contact: '0300-9876543',
    codAmount: 2500,
    city: 'Otherville',
    zone: 'B',
    status: 'In Transit',
    bookingDate: new Date(Date.now() - 1 * 24 * 60 * 60 * 1000).toISOString(),
    sellerId: 'user-1',
    orderReferenceNumber: 'REF002'
  },
  {
    id: 'PCL162820',
    recipientName: 'Zainab Corporation',
    address: 'Plot 55, Industrial Area, I-9/3',
    contact: '0312-3456789',
    codAmount: 500,
    city: 'Anytown',
    zone: 'C',
    status: 'Pending',
    bookingDate: new Date().toISOString(),
    sellerId: 'user-1',
    orderReferenceNumber: 'REF003'
  },
  {
    id: 'PCL162821',
    recipientName: 'Sana Ahmed',
    address: 'B-567, Block 10, Gulshan-e-Iqbal',
    contact: '0345-1122334',
    codAmount: 3000,
    city: 'Otherville',
    zone: 'A',
    status: 'Picked Up',
    bookingDate: new Date(Date.now() - 8 * 24 * 60 * 60 * 1000).toISOString(),
    sellerId: 'user-1',
    orderReferenceNumber: 'REF004'
  },
  {
    id: 'PCL162822',
    recipientName: 'Kamran Traders',
    address: 'Shop 8, Main Market, F-7 Markaz',
    contact: '0321-4455667',
    codAmount: 1200,
    city: 'Anytown',
    zone: 'B',
    status: 'Returned',
    bookingDate: new Date(Date.now() - 3 * 24 * 60 * 60 * 1000).toISOString(),
    sellerId: 'user-1',
    orderReferenceNumber: 'REF005'
  },
  {
    id: 'PCL162823',
    recipientName: 'Global Imports',
    address: 'Warehouse 12, Site Area',
    contact: '0334-7890123',
    codAmount: 7500,
    city: 'Otherville',
    zone: 'C',
    status: 'Delivered',
    bookingDate: new Date(Date.now() - 10 * 24 * 60 * 60 * 1000).toISOString(),
    sellerId: 'user-2',
    orderReferenceNumber: 'REF006'
  },
  {
    id: 'PCL162824',
    recipientName: 'Hassan Ali',
    address: 'Apartment 15, Park Towers, Clifton',
    contact: '0301-2345678',
    codAmount: 850,
    city: 'Anytown',
    zone: 'A',
    status: 'Picked Up',
    bookingDate: new Date(Date.now() - 9 * 24 * 60 * 60 * 1000).toISOString(),
    sellerId: 'user-1',
    orderReferenceNumber: 'REF007'
  },
];

export const historicalDeliveryData: { city: string; zone: string; deliveryTime: string; }[] = [
    { city: "Anytown", zone: "A", deliveryTime: "2" },
    { city: "Anytown", zone: "B", deliveryTime: "3" },
    { city: "Anytown", zone: "C", deliveryTime: "4" },
];

export const mockComplaints: Complaint[] = [
    { id: 'CMP-001', parcelId: 'PCL162822', subject: 'Parcel Returned Undelivered', description: 'The parcel was returned but the reason is unclear. Please investigate.', status: 'In Progress', date: new Date(Date.now() - 2 * 24 * 60 * 60 * 1000).toISOString(), sellerId: 'user-1' },
    { id: 'CMP-002', parcelId: 'PCL162819', subject: 'Delivery is delayed', description: 'The parcel is still in transit after 3 days. The customer is asking for an update.', status: 'Open', date: new Date(Date.now() - 1 * 24 * 60 * 60 * 1000).toISOString(), sellerId: 'user-1' },
    { id: 'CMP-003', parcelId: 'PCL162818', subject: 'COD amount not remitted', description: 'The parcel was delivered 5 days ago but the COD amount has not been credited to my wallet.', status: 'Resolved', date: new Date(Date.now() - 10 * 24 * 60 * 60 * 1000).toISOString(), sellerId: 'user-1' },
];

export const mockNews: NewsItem[] = [
  {
    id: 'news-1',
    title: 'New Mobile App Launch!',
    content: 'We are excited to announce the launch of our new mobile app, available now on Android and iOS. Manage your shipments on the go!',
    date: new Date(Date.now() - 1 * 24 * 60 * 60 * 1000).toISOString(),
    category: 'Announcement',
  },
  {
    id: 'news-2',
    title: 'Service Update: Faster Deliveries in Otherville',
    content: 'We have expanded our operations in Otherville, resulting in a 20% improvement in average delivery times. Thank you for your continued support.',
    date: new Date(Date.now() - 3 * 24 * 60 * 60 * 1000).toISOString(),
    category: 'Update',
  },
  {
    id: 'news-3',
    title: 'Scheduled Maintenance on July 30th',
    content: 'Our platform will undergo scheduled maintenance on July 30th from 2:00 AM to 4:00 AM. Services may be temporarily unavailable.',
    date: new Date(Date.now() - 5 * 24 * 60 * 60 * 1000).toISOString(),
    category: 'Maintenance',
  },
];
