

<?php $__env->startSection('title', 'Alerts'); ?>

<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <div class="mb-4 sm:mb-6">
        <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Alerts</h1>
        <p class="text-xs sm:text-sm text-gray-600 mt-1">Monitor and act on marketing alerts</p>
    </div>

    <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6">
        <!-- Filters -->
        <div class="grid grid-cols-1 md:grid-cols-5 gap-4 mb-4">
            <div>
                <label class="text-sm text-gray-700">Status</label>
                <select id="filter-status" class="mt-1 w-full rounded-md border-gray-300">
                    <option value="">All</option>
                    <option value="new">New</option>
                    <option value="acknowledged">Acknowledged</option>
                    <option value="snoozed">Snoozed</option>
                    <option value="resolved">Resolved</option>
                </select>
            </div>
            <div>
                <label class="text-sm text-gray-700">Severity</label>
                <select id="filter-severity" class="mt-1 w-full rounded-md border-gray-300">
                    <option value="">All</option>
                    <option value="info">Info</option>
                    <option value="warning">Warning</option>
                    <option value="critical">Critical</option>
                </select>
            </div>
            <div>
                <label class="text-sm text-gray-700">Category</label>
                <select id="filter-category" class="mt-1 w-full rounded-md border-gray-300">
                    <option value="">All</option>
                    <option value="campaign">Campaign</option>
                    <option value="rate">Rate</option>
                    <option value="compliance">Compliance</option>
                    <option value="expiry">Expiry</option>
                </select>
            </div>
            <div>
                <label class="text-sm text-gray-700">Start date</label>
                <input type="date" id="filter-start" class="mt-1 w-full rounded-md border-gray-300" />
            </div>
            <div>
                <label class="text-sm text-gray-700">End date</label>
                <input type="date" id="filter-end" class="mt-1 w-full rounded-md border-gray-300" />
            </div>
        </div>

        <div class="flex items-center gap-2 mb-4">
            <button id="apply-filters" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">Apply</button>
            <button id="reset-filters" class="bg-gray-200 text-gray-800 px-4 py-2 rounded hover:bg-gray-300">Reset</button>
        </div>

        <!-- Alerts Table -->
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-2 text-left text-xs font-medium text-gray-500">Title</th>
                        <th class="px-4 py-2 text-left text-xs font-medium text-gray-500">Severity</th>
                        <th class="px-4 py-2 text-left text-xs font-medium text-gray-500">Category</th>
                        <th class="px-4 py-2 text-left text-xs font-medium text-gray-500">Triggered</th>
                        <th class="px-4 py-2 text-left text-xs font-medium text-gray-500">Status</th>
                        <th class="px-4 py-2 text-left text-xs font-medium text-gray-500">Actions</th>
                    </tr>
                </thead>
                <tbody id="alerts-body" class="bg-white divide-y divide-gray-200">
                    <tr>
                        <td colspan="6" class="px-4 py-3 text-center text-gray-500">Loading alerts...</td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
    
    <?php $__env->startPush('scripts'); ?>
    <script>
        const buildQuery = () => {
            const params = new URLSearchParams();
            const status = document.getElementById('filter-status').value;
            const severity = document.getElementById('filter-severity').value;
            const category = document.getElementById('filter-category').value;
            const start = document.getElementById('filter-start').value;
            const end = document.getElementById('filter-end').value;
            if (status) params.set('status', status);
            if (severity) params.set('severity', severity);
            if (category) params.set('category', category);
            if (start) params.set('start', start);
            if (end) params.set('end', end);
            return params.toString();
        };

        async function loadAlerts() {
            const tbody = document.getElementById('alerts-body');
            tbody.innerHTML = `<tr><td colspan="6" class="px-4 py-3 text-center text-gray-500">Loading alerts...</td></tr>`;
            try {
                const res = await fetch(`<?php echo e(route('admin.marketing.alerts.data')); ?>?${buildQuery()}`);
                const data = await res.json();
                const alerts = data.alerts || [];
                if (!alerts.length) {
                    tbody.innerHTML = `<tr><td colspan="6" class="px-4 py-3 text-center text-gray-500">No alerts found</td></tr>`;
                    return;
                }
                tbody.innerHTML = alerts.map(a => {
                    const triggered = a.triggered_at ? new Date(a.triggered_at).toLocaleString() : '-';
                    const statusBadge = {
                        new: 'bg-blue-100 text-blue-800',
                        acknowledged: 'bg-green-100 text-green-800',
                        snoozed: 'bg-yellow-100 text-yellow-800',
                        resolved: 'bg-gray-100 text-gray-800'
                    }[a.status] || 'bg-gray-100 text-gray-800';
                    const severityBadge = {
                        info: 'bg-blue-100 text-blue-800',
                        warning: 'bg-yellow-100 text-yellow-800',
                        critical: 'bg-red-100 text-red-800'
                    }[a.severity] || 'bg-gray-100 text-gray-800';
                    return `
                        <tr>
                            <td class="px-4 py-2">
                                <div class="font-medium text-gray-900">${a.title}</div>
                                <div class="text-sm text-gray-600">${a.description || ''}</div>
                            </td>
                            <td class="px-4 py-2">
                                <span class="px-2 py-1 rounded ${severityBadge}">${a.severity}</span>
                            </td>
                            <td class="px-4 py-2">${a.category || '-'}</td>
                            <td class="px-4 py-2">${triggered}</td>
                            <td class="px-4 py-2">
                                <span class="px-2 py-1 rounded ${statusBadge}">${a.status}</span>
                            </td>
                            <td class="px-4 py-2">
                                <div class="flex gap-2 sm:gap-3">
                                    <button class="bg-green-600 text-white px-3 py-1 rounded hover:bg-green-700" onclick="ackAlert(${a.id})">Acknowledge</button>
                                    <button class="bg-yellow-600 text-white px-3 py-1 rounded hover:bg-yellow-700" onclick="promptSnooze(${a.id})">Snooze</button>
                                </div>
                            </td>
                        </tr>
                    `;
                }).join('');
            } catch (e) {
                tbody.innerHTML = `<tr><td colspan="6" class="px-4 py-3 text-center text-red-600">Failed to load alerts</td></tr>`;
            }
        }

        async function ackAlert(id) {
            try {
                await fetch(`<?php echo e(route('admin.marketing.alerts.acknowledge', ['alert' => 0])); ?>`.replace('0', id), {
                    method: 'POST',
                    headers: { 'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>' }
                });
                loadAlerts();
            } catch (e) {}
        }

        async function snoozeAlert(id, minutes) {
            try {
                await fetch(`<?php echo e(route('admin.marketing.alerts.snooze', ['alert' => 0])); ?>`.replace('0', id), {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                    },
                    body: JSON.stringify({ minutes })
                });
                loadAlerts();
            } catch (e) {}
        }

        function promptSnooze(id) {
            const minutes = parseInt(prompt('Snooze for how many minutes?', '60'), 10);
            if (!isNaN(minutes) && minutes > 0) {
                snoozeAlert(id, minutes);
            }
        }

        document.getElementById('apply-filters').addEventListener('click', loadAlerts);
        document.getElementById('reset-filters').addEventListener('click', () => {
            document.getElementById('filter-status').value = '';
            document.getElementById('filter-severity').value = '';
            document.getElementById('filter-category').value = '';
            document.getElementById('filter-start').value = '';
            document.getElementById('filter-end').value = '';
            loadAlerts();
        });

        document.addEventListener('DOMContentLoaded', loadAlerts);
    </script>
    <?php $__env->stopPush(); ?>
</div>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\download\project\final cms\laravel-cms\resources\views/admin/marketing/alerts.blade.php ENDPATH**/ ?>