

<?php $__env->startSection('title', 'Merchant Invoices - Admin'); ?>
<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <!-- Header -->
    <div class="mb-4 sm:mb-6 flex flex-col sm:flex-row justify-between items-start sm:items-center gap-3">
        <div>
            <div class="flex justify-between items-center">
                <h3 class="text-lg font-semibold">All Invoices</h3>
<form method="GET" action="<?php echo e(route('finance.settlements.invoices.index')); ?>" class="flex items-center space-x-2">
                    <label for="start_date" class="text-xs sm:text-sm font-medium text-gray-700">Start Date</label>
                    <input type="date" name="start_date" id="start_date" class="form-input" value="<?php echo e(request('start_date')); ?>">
                    <label for="end_date" class="text-xs sm:text-sm font-medium text-gray-700">End Date</label>
                    <input type="date" name="end_date" id="end_date" class="form-input" value="<?php echo e(request('end_date')); ?>">
                    <button type="submit" class="btn-primary">Filter</button>
                </form>
            </div>
            <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Merchant Invoices</h1>
            <p class="text-xs sm:text-sm text-gray-600 mt-1">Manage merchant settlement invoices</p>
        </div>
<a href="<?php echo e(route('finance.settlements.invoices.create')); ?>" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">
            <svg class="w-4 h-4 sm:w-5 sm:h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/>
            </svg>
            Create Invoice
        </a>
    </div>

    <?php if(session('success')): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-3 sm:px-4 py-2 sm:py-3 rounded relative mb-4 text-xs sm:text-sm">
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    <!-- Stats Cards -->
    <div class="grid grid-cols-2 lg:grid-cols-4 gap-3 sm:gap-4 mb-4 sm:mb-6">
        <div class="bg-white rounded-lg shadow-md p-3 sm:p-4">
            <p class="text-[10px] sm:text-xs text-gray-600">Total Invoices</p>
            <p class="text-lg sm:text-2xl font-bold text-gray-900">24</p>
        </div>
        <div class="bg-white rounded-lg shadow-md p-3 sm:p-4">
            <p class="text-[10px] sm:text-xs text-gray-600">Pending</p>
            <p class="text-lg sm:text-2xl font-bold text-yellow-600">8</p>
        </div>
        <div class="bg-white rounded-lg shadow-md p-3 sm:p-4">
            <p class="text-[10px] sm:text-xs text-gray-600">Paid</p>
            <p class="text-lg sm:text-2xl font-bold text-green-600">14</p>
        </div>
        <div class="bg-white rounded-lg shadow-md p-3 sm:p-4">
            <p class="text-[10px] sm:text-xs text-gray-600">Total Amount</p>
            <p class="text-lg sm:text-2xl font-bold text-gray-900">Rs. 2.5M</p>
        </div>
    </div>

    <!-- Invoices Table -->
    <div class="bg-white rounded-lg shadow-md overflow-hidden">
        <div class="p-4 border-b">
            <input type="text" placeholder="Search invoices..." class="w-full border border-gray-300 rounded-md px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm focus:outline-none focus:ring-2 focus:ring-blue-500">
        </div>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Invoice #</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Merchant</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Amount</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Date</th>
                        <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php $__empty_1 = true; $__currentLoopData = $invoices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr class="hover:bg-gray-50">
                        <td class="px-4 py-3 text-sm"><?php echo e($invoice->invoice_number); ?></td>
                        <td class="px-4 py-3 text-sm"><?php echo e($invoice->merchant->name ?? 'N/A'); ?></td>
                        <td class="px-4 py-3 text-sm">Rs. <?php echo e(number_format($invoice->total_amount, 2)); ?></td>
                        <td class="px-4 py-3 text-sm">
                            <?php if($invoice->status == 'draft'): ?>
                                <span class="px-2 py-1 text-xs rounded-full bg-gray-200 text-gray-800">Draft</span>
                            <?php elseif($invoice->status == 'sent'): ?>
                                <span class="px-2 py-1 text-xs rounded-full bg-blue-200 text-blue-800">Sent</span>
                            <?php elseif($invoice->status == 'paid'): ?>
                                <span class="px-2 py-1 text-xs rounded-full bg-green-200 text-green-800">Paid</span>
                            <?php elseif($invoice->status == 'overdue'): ?>
                                <span class="px-2 py-1 text-xs rounded-full bg-red-200 text-red-800">Overdue</span>
                            <?php else: ?>
                                <span class="px-2 py-1 text-xs rounded-full bg-gray-200 text-gray-800"><?php echo e(ucfirst($invoice->status)); ?></span>
                            <?php endif; ?>
                        </td>
                        <td class="px-4 py-3 text-sm"><?php echo e($invoice->invoice_date->format('M d, Y')); ?></td>
                        <td class="px-4 py-3 text-sm">
                            <div class="flex gap-2 sm:gap-3">
                                <a href="<?php echo e(route('finance.settlements.invoices.show', $invoice)); ?>" class="text-blue-600 hover:text-blue-800" title="View">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/>
                                    </svg>
                                </a>
                                <a href="<?php echo e(route('finance.settlements.invoices.edit', $invoice)); ?>" class="text-yellow-600 hover:text-yellow-800" title="Edit">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/>
                                    </svg>
                                </a>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="6" class="px-6 py-12 text-center text-gray-500">
                            <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                            </svg>
                            <p class="mt-4">No invoices found</p>
                            <p class="text-sm mt-2">Create your first invoice to get started</p>
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <?php if($invoices->hasPages()): ?>
        <div class="px-4 py-3 border-t">
            <?php echo e($invoices->links()); ?>

        </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\download\project\final cms\laravel-cms\resources\views/admin/finance/settlements/invoices/index.blade.php ENDPATH**/ ?>