

<?php $__env->startSection('title', 'Order Logs'); ?>

<?php $__env->startSection('content'); ?>
<div class="flex flex-col gap-8">
    <div class="flex items-center justify-end">
        <a href="<?php echo e(route('seller.orders.create')); ?>" class="bg-blue-600 text-white px-4 py-2 rounded-md font-semibold hover:bg-blue-700 transition">
            <i class="fas fa-plus-circle mr-2"></i>
            Create Order
        </a>
    </div>
    <div class="bg-white rounded-lg shadow-md">
        <div class="p-4 border-b">
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div class="flex items-center gap-1 border-b flex-wrap">
                    <a href="<?php echo e(route('seller.orders.logs')); ?>" class="py-2 px-3 border-b-2 <?php echo e(request('tab') == '' ? 'border-blue-500 text-blue-600' : 'border-transparent text-gray-500 hover:text-gray-700'); ?> text-xs h-8">All (<?php echo e($allCount); ?>)</a>
                    <a href="<?php echo e(route('seller.orders.logs', ['tab' => 'Booked'])); ?>" class="py-2 px-3 border-b-2 <?php echo e(request('tab') == 'Booked' ? 'border-blue-500 text-blue-600' : 'border-transparent text-gray-500 hover:text-gray-700'); ?> text-xs h-8">Booked (<?php echo e($bookedCount); ?>)</a>
                    <a href="<?php echo e(route('seller.orders.logs', ['tab' => 'Pending'])); ?>" class="py-2 px-3 border-b-2 <?php echo e(request('tab') == 'Pending' ? 'border-blue-500 text-blue-600' : 'border-transparent text-gray-500 hover:text-gray-700'); ?> text-xs h-8">Unbooked (<?php echo e($unbookedCount); ?>)</a>
                    <a href="<?php echo e(route('seller.orders.logs', ['tab' => 'In Transit'])); ?>" class="py-2 px-3 border-b-2 <?php echo e(request('tab') == 'In Transit' ? 'border-blue-500 text-blue-600' : 'border-transparent text-gray-500 hover:text-gray-700'); ?> text-xs h-8">In-Transit (<?php echo e($inTransitCount); ?>)</a>
                    <a href="<?php echo e(route('seller.orders.logs', ['tab' => 'Delivered'])); ?>" class="py-2 px-3 border-b-2 <?php echo e(request('tab') == 'Delivered' ? 'border-blue-500 text-blue-600' : 'border-transparent text-gray-500 hover:text-gray-700'); ?> text-xs h-8">Delivered (<?php echo e($deliveredCount); ?>)</a>
                    <a href="<?php echo e(route('seller.orders.logs', ['tab' => 'Returned'])); ?>" class="py-2 px-3 border-b-2 <?php echo e(request('tab') == 'Returned' ? 'border-blue-500 text-blue-600' : 'border-transparent text-gray-500 hover:text-gray-700'); ?> text-xs h-8">Returned (<?php echo e($returnedCount); ?>)</a>
                    <a href="<?php echo e(route('seller.orders.logs', ['tab' => 'Cancelled'])); ?>" class="py-2 px-3 border-b-2 <?php echo e(request('tab') == 'Cancelled' ? 'border-blue-500 text-blue-600' : 'border-transparent text-gray-500 hover:text-gray-700'); ?> text-xs h-8">Cancelled (<?php echo e($cancelledCount); ?>)</a>
                </div>
                <div class="flex items-center gap-2">
                    <button class="bg-gray-200 text-gray-700 p-2 rounded-md"><i class="fas fa-sync-alt"></i></button>
                    <button class="bg-gray-200 text-gray-700 p-2 rounded-md"><i class="fas fa-cloud-upload-alt"></i></button>
                    <button class="bg-gray-200 text-gray-700 p-2 rounded-md"><i class="fas fa-download"></i></button>
                    <button class="bg-gray-200 text-gray-700 p-2 rounded-md"><i class="fas fa-print"></i></button>
                    <button class="bg-gray-200 text-gray-700 p-2 rounded-md"><i class="fas fa-cog"></i></button>
                </div>
            </div>
        </div>
        <div class="p-6 space-y-6">
            <div class="p-4 border rounded-lg bg-gray-50">
                <p class="text-sm font-semibold mb-4">ADVANCED SEARCH</p>
                <form action="<?php echo e(route('seller.orders.logs')); ?>" method="GET" class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
                    <input type="hidden" name="tab" value="<?php echo e(request('tab')); ?>">
                    <div class="lg:col-span-2">
                        <label class="text-xs text-gray-500">Search by</label>
                        <div class="flex">
                            <input type="text" name="search" value="<?php echo e(request('search')); ?>" placeholder="Search..." class="w-full border-gray-300 rounded-l-md shadow-sm">
                            <select name="search_type" class="w-auto min-w-[160px] border-gray-300 rounded-r-md shadow-sm border-l-0">
                                <option value="tracking_id" <?php if(request('search_type') == 'tracking_id'): echo 'selected'; endif; ?>>TRACKING #</option>
                                <option value="recipient_name" <?php if(request('search_type') == 'recipient_name'): echo 'selected'; endif; ?>>NAME</option>
                            </select>
                        </div>
                    </div>
                    <div>
                        <label class="text-xs text-gray-500">FROM</label>
                        <input type="date" name="from_date" value="<?php echo e(request('from_date')); ?>" class="w-full border-gray-300 rounded-md shadow-sm">
                    </div>
                    <div>
                        <label class="text-xs text-gray-500">TO</label>
                        <input type="date" name="to_date" value="<?php echo e(request('to_date')); ?>" class="w-full border-gray-300 rounded-md shadow-sm">
                    </div>
                    <div class="flex items-end gap-2">
                        <button type="submit" class="w-full bg-blue-600 text-white px-4 py-2 rounded-md font-semibold">Search</button>
                        <a href="<?php echo e(route('seller.orders.logs', ['tab' => request('tab')])); ?>" class="w-full bg-gray-200 text-gray-700 px-4 py-2 rounded-md font-semibold text-center">Clear Filter</a>
                    </div>
                </form>
            </div>

            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead>
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase"><input type="checkbox"></th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Order Ref</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Tracking #</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Weight</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Delivery Address</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Amount</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Action</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td class="px-6 py-4 whitespace-nowrap text-sm"><input type="checkbox"></td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo e($order->order_ref ?? 'N/A'); ?></td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-blue-600"><?php echo e($order->tracking_id); ?></td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?php echo e($order->parcel_weight); ?>kg</td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo e($order->recipient_address); ?></td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">PKR <?php echo e(number_format($order->cod_amount, 2)); ?></td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm">
                                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full <?php echo e($order->trashed() ? 'bg-red-100 text-red-800' : 'bg-blue-100 text-blue-800'); ?>"><?php echo e($order->trashed() ? 'Cancelled' : $order->status); ?></span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                <a href="#" class="text-blue-600 hover:text-blue-900"><i class="fas fa-copy"></i></a>
                                <a href="<?php echo e(route('seller.orders.edit', $order)); ?>" class="text-blue-600 hover:text-blue-900 ml-2"><i class="fas fa-pencil-alt"></i></a>
                                <?php if(!$order->trashed()): ?>
                                <form action="<?php echo e(route('seller.orders.destroy', $order)); ?>" method="POST" class="inline-block ml-2">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="text-red-600 hover:text-red-900"><i class="fas fa-trash"></i></button>
                                </form>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="9" class="text-center py-10 text-sm text-gray-500">No orders found.</td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
                <div class="mt-4">
                    <?php echo e($orders->appends(request()->query())->links()); ?>

                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.seller', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\download\project\final cms\laravel-cms\resources\views/seller/orders/logs.blade.php ENDPATH**/ ?>