

<?php $__env->startSection('title', 'Parcels Management - Admin'); ?>

<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-2 sm:px-4 lg:px-6 py-3 sm:py-4 lg:py-6">
    <!-- Header -->
    <div class="mb-4 sm:mb-6">
        <h1 class="text-xl sm:text-2xl lg:text-3xl font-bold text-gray-900">Parcels Management</h1>
        <p class="text-xs sm:text-sm text-gray-600 mt-1">Manage and track all parcels in the system</p>
    </div>

    <?php if(session('success')): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded relative mb-4" role="alert">
            <span class="block sm:inline"><?php echo e(session('success')); ?></span>
        </div>
    <?php endif; ?>

    <!-- Stats Cards -->
    <div class="grid grid-cols-2 lg:grid-cols-4 gap-3 sm:gap-4 lg:gap-6 mb-4 sm:mb-6">
        <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6">
            <div class="flex items-center">
                <div class="flex-shrink-0 bg-blue-500 rounded-md p-2 sm:p-2.5 lg:p-3">
                    <svg class="h-4 w-4 sm:h-5 sm:w-5 lg:h-6 lg:w-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 13V6a2 2 0 00-2-2H6a2 2 0 00-2 2v7m16 0v5a2 2 0 01-2 2H6a2 2 0 01-2-2v-5m16 0h-2.586a1 1 0 00-.707.293l-2.414 2.414a1 1 0 01-.707.293h-3.172a1 1 0 01-.707-.293l-2.414-2.414A1 1 0 006.586 13H4"/>
                    </svg>
                </div>
                <div class="ml-2 sm:ml-3 lg:ml-4">
                    <p class="text-[10px] sm:text-xs lg:text-sm font-medium text-gray-600">Total Parcels</p>
                    <p class="text-base sm:text-xl lg:text-2xl font-bold text-gray-900"><?php echo e(number_format($parcels->total())); ?></p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6">
            <div class="flex items-center">
                <div class="flex-shrink-0 bg-yellow-500 rounded-md p-2 sm:p-2.5 lg:p-3">
                    <svg class="h-4 w-4 sm:h-5 sm:w-5 lg:h-6 lg:w-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"/>
                    </svg>
                </div>
                <div class="ml-2 sm:ml-3 lg:ml-4">
                    <p class="text-[10px] sm:text-xs lg:text-sm font-medium text-gray-600">Pending</p>
                    <p class="text-base sm:text-xl lg:text-2xl font-bold text-gray-900"><?php echo e($statusCounts['Pending'] ?? 0); ?></p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6">
            <div class="flex items-center">
                <div class="flex-shrink-0 bg-green-500 rounded-md p-2 sm:p-2.5 lg:p-3">
                    <svg class="h-4 w-4 sm:h-5 sm:w-5 lg:h-6 lg:w-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                    </svg>
                </div>
                <div class="ml-2 sm:ml-3 lg:ml-4">
                    <p class="text-[10px] sm:text-xs lg:text-sm font-medium text-gray-600">Delivered</p>
                    <p class="text-base sm:text-xl lg:text-2xl font-bold text-gray-900"><?php echo e($statusCounts['Delivered'] ?? 0); ?></p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6">
            <div class="flex items-center">
                <div class="flex-shrink-0 bg-purple-500 rounded-md p-2 sm:p-2.5 lg:p-3">
                    <svg class="h-4 w-4 sm:h-5 sm:w-5 lg:h-6 lg:w-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"/>
                    </svg>
                </div>
                <div class="ml-2 sm:ml-3 lg:ml-4">
                    <p class="text-[10px] sm:text-xs lg:text-sm font-medium text-gray-600">In Transit</p>
                    <p class="text-base sm:text-xl lg:text-2xl font-bold text-gray-900"><?php echo e($statusCounts['In Transit'] ?? 0); ?></p>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters and Search -->
    <div class="bg-white rounded-lg shadow-md p-3 sm:p-4 lg:p-6 mb-4 sm:mb-6">
        <form method="GET" action="<?php echo e(route('admin.parcels.index')); ?>" class="space-y-3 sm:space-y-4">
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-3 sm:gap-4">
                <!-- Search -->
                <div>
                    <label for="search" class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">Search</label>
                    <input type="text" name="search" id="search" value="<?php echo e(request('search')); ?>" 
                           placeholder="Tracking ID, Name..." 
                           class="w-full px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>

                <!-- Status Filter -->
                <div>
                    <label for="status" class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">Status</label>
                    <select name="status" id="status" class="w-full px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                        <option value="all">All Statuses</option>
                        <option value="Pending" <?php echo e(request('status') == 'Pending' ? 'selected' : ''); ?>>Pending</option>
                        <option value="Picked Up" <?php echo e(request('status') == 'Picked Up' ? 'selected' : ''); ?>>Picked Up</option>
                        <option value="In Transit" <?php echo e(request('status') == 'In Transit' ? 'selected' : ''); ?>>In Transit</option>
                        <option value="Delivered" <?php echo e(request('status') == 'Delivered' ? 'selected' : ''); ?>>Delivered</option>
                        <option value="Returned" <?php echo e(request('status') == 'Returned' ? 'selected' : ''); ?>>Returned</option>
                        <option value="Failed" <?php echo e(request('status') == 'Failed' ? 'selected' : ''); ?>>Failed</option>
                        <option value="In Warehouse" <?php echo e(request('status') == 'In Warehouse' ? 'selected' : ''); ?>>In Warehouse</option>
                        <option value="Out for Delivery" <?php echo e(request('status') == 'Out for Delivery' ? 'selected' : ''); ?>>Out for Delivery</option>
                    </select>
                </div>

                <!-- Date Range -->
                <div>
                    <label for="date_from" class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">From Date</label>
                    <input type="date" name="date_from" id="date_from" value="<?php echo e(request('date_from')); ?>" 
                           class="w-full px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>

                <div>
                    <label for="date_to" class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">To Date</label>
                    <input type="date" name="date_to" id="date_to" value="<?php echo e(request('date_to')); ?>" 
                           class="w-full px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>
            </div>

            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-3 sm:gap-4">
                <!-- City Filter -->
                <div>
                    <label for="city" class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">City</label>
                    <input type="text" name="city" id="city" value="<?php echo e(request('city')); ?>" 
                           placeholder="Filter by city" 
                           class="w-full px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>

                <!-- Zone Filter -->
                <div>
                    <label for="zone" class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">Zone</label>
                    <input type="text" name="zone" id="zone" value="<?php echo e(request('zone')); ?>" 
                           placeholder="Filter by zone" 
                           class="w-full px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                </div>

                <!-- Seller Filter -->
                <div>
                    <label for="seller_id" class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">Seller</label>
                    <select name="seller_id" id="seller_id" class="w-full px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                        <option value="">All Sellers</option>
                        <?php $__currentLoopData = $sellers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $seller): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($seller->id); ?>" <?php echo e(request('seller_id') == $seller->id ? 'selected' : ''); ?>>
                                <?php echo e($seller->name); ?> (<?php echo e($seller->company_name); ?>)
                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <!-- Rider Filter -->
                <div>
                    <label for="rider_id" class="block text-xs sm:text-sm font-medium text-gray-700 mb-1">Rider</label>
                    <select name="rider_id" id="rider_id" class="w-full px-2 sm:px-3 py-1.5 sm:py-2 text-xs sm:text-sm border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500">
                        <option value="">All Riders</option>
                        <?php $__currentLoopData = $riders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($rider->id); ?>" <?php echo e(request('rider_id') == $rider->id ? 'selected' : ''); ?>>
                                <?php echo e($rider->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>

            <div class="flex flex-col sm:flex-row justify-end gap-2 sm:gap-3">
                <a href="<?php echo e(route('admin.parcels.index')); ?>" class="px-3 sm:px-4 py-1.5 sm:py-2 text-xs sm:text-sm border border-gray-300 rounded-md text-gray-700 hover:bg-gray-50 text-center">
                    Clear Filters
                </a>
                <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">
                    Apply Filters
                </button>
            </div>
        </form>
    </div>

    <!-- Bulk Actions -->
    <div class="bg-white rounded-lg shadow-md p-4 mb-6" x-data="{ selectedParcels: [], selectAll: false }">
        <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between gap-4">
            <div class="flex flex-col sm:flex-row sm:items-center gap-2 sm:gap-4">
                <span class="text-sm text-gray-600">
                    <span x-text="selectedParcels.length"></span> parcel(s) selected
                </span>
                <button @click="selectAll = !selectAll; selectedParcels = selectAll ? <?php echo e($parcels->pluck('id')); ?> : []" 
                        class="text-sm text-blue-600 hover:text-blue-800 text-left sm:text-center">
                    <span x-text="selectAll ? 'Deselect All' : 'Select All on Page'"></span>
                </button>
            </div>
            
            <div class="flex flex-col sm:flex-row gap-2 sm:gap-3" x-show="selectedParcels.length > 0">
                <form method="POST" action="<?php echo e(route('admin.parcels.bulk-update')); ?>" class="flex flex-col sm:flex-row gap-2 sm:gap-3">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="parcel_ids" x-bind:value="selectedParcels.join(',')">
                    <select name="bulk_status" class="px-3 py-2 border border-gray-300 rounded-md text-sm w-full sm:w-auto" required>
                        <option value="">Change Status...</option>
                        <option value="Picked Up">Picked Up</option>
                        <option value="In Transit">In Transit</option>
                        <option value="Out for Delivery">Out for Delivery</option>
                        <option value="Delivered">Delivered</option>
                        <option value="Failed">Failed</option>
                        <option value="Returned">Returned</option>
                    </select>
                    <button type="submit" class="bg-blue-600 text-white px-3 sm:px-4 py-2 rounded-md text-xs sm:text-sm font-semibold hover:bg-blue-700 transition">
                        Update Status
                    </button>
                </form>

                <button onclick="printLabels()" class="px-4 py-2 bg-green-600 text-white rounded-md hover:bg-green-700 text-sm w-full sm:w-auto">
                    Print Labels
                </button>

                <button onclick="exportSelected()" class="px-4 py-2 bg-purple-600 text-white rounded-md hover:bg-purple-700 text-sm w-full sm:w-auto">
                    Export Excel
                </button>
            </div>
        </div>
    </div>

    <!-- Parcels Table -->
    <div class="bg-white rounded-lg shadow-md overflow-hidden">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left">
                            <input type="checkbox" class="rounded border-gray-300" @change="selectAll = !selectAll; selectedParcels = selectAll ? <?php echo e($parcels->pluck('id')); ?> : []">
                        </th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">
                            Tracking ID
                        </th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">
                            Recipient
                        </th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">
                            Seller
                        </th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">
                            City/Zone
                        </th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">
                            COD Amount
                        </th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">
                            Status
                        </th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">
                            Rider
                        </th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">
                            Booking Date
                        </th>
                        <th class="px-4 py-2 text-left text-[11px] font-medium text-gray-500 uppercase tracking-wider">
                            Actions
                        </th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php $__empty_1 = true; $__currentLoopData = $parcels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $parcel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="hover:bg-gray-50">
                            <td class="px-6 py-4">
                                <input type="checkbox" class="rounded border-gray-300" 
                                       x-model="selectedParcels" 
                                       value="<?php echo e($parcel->id); ?>">
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="flex items-center">
                                    <div class="text-sm font-medium text-blue-600">
                                        <a href="<?php echo e(route('admin.parcels.show', $parcel)); ?>" class="hover:underline">
                                            <?php echo e($parcel->tracking_id); ?>

                                        </a>
                                    </div>
                                </div>
                            </td>
                            <td class="px-6 py-4">
                                <div class="text-sm font-medium text-gray-900"><?php echo e($parcel->recipient_name); ?></div>
                                <div class="text-sm text-gray-500"><?php echo e($parcel->contact); ?></div>
                            </td>
                            <td class="px-6 py-4">
                                <div class="text-sm text-gray-900"><?php echo e($parcel->seller->name); ?></div>
                                <div class="text-sm text-gray-500"><?php echo e($parcel->seller->company_name); ?></div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-sm text-gray-900"><?php echo e($parcel->city); ?></div>
                                <div class="text-sm text-gray-500">Zone: <?php echo e($parcel->zone); ?></div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="text-sm font-semibold text-gray-900">Rs. <?php echo e(number_format($parcel->cod_amount, 2)); ?></div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <span class="px-2 inline-flex text-[10px] leading-4 font-semibold rounded-full 
                                    <?php if($parcel->status == 'Delivered'): ?> bg-green-100 text-green-800
                                    <?php elseif($parcel->status == 'Pending'): ?> bg-yellow-100 text-yellow-800
                                    <?php elseif($parcel->status == 'In Transit' || $parcel->status == 'Picked Up'): ?> bg-blue-100 text-blue-800
                                    <?php elseif($parcel->status == 'Failed' || $parcel->status == 'Returned'): ?> bg-red-100 text-red-800
                                    <?php else: ?> bg-gray-100 text-gray-800
                                    <?php endif; ?>">
                                    <?php echo e($parcel->status); ?>

                                </span>
                            </td>
                            <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-500">
                                <?php echo e($parcel->rider?->name ?? 'Unassigned'); ?>

                            </td>
                            <td class="px-4 py-2.5 whitespace-nowrap text-xs text-gray-500">
                                <?php echo e($parcel->booking_date->format('M d, Y')); ?>

                            </td>
                            <td class="px-4 py-2.5 whitespace-nowrap text-xs font-medium">
                                <div class="flex space-x-2">
                                    <a href="<?php echo e(route('admin.parcels.show', $parcel)); ?>" 
                                       class="text-blue-600 hover:text-blue-900" title="View Details">
                                        <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/>
                                        </svg>
                                    </a>
                                    <a href="<?php echo e(route('admin.parcels.edit', $parcel)); ?>" 
                                       class="text-green-600 hover:text-green-900" title="Edit">
                                        <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"/>
                                        </svg>
                                    </a>
                                    <button onclick="printLabel(<?php echo e($parcel->id); ?>)" 
                                            class="text-purple-600 hover:text-purple-900" title="Print Label">
                                        <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h6a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2 2v4h10z"/>
                                        </svg>
                                    </button>
                                    <form method="POST" action="<?php echo e(route('admin.parcels.destroy', $parcel)); ?>" 
                                          class="inline" onsubmit="return confirm('Are you sure you want to delete this parcel?');">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="text-red-600 hover:text-red-900" title="Delete">
                                            <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"/>
                                            </svg>
                                        </button>
                                    </form>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="10" class="px-6 py-12 text-center text-gray-500">
                                <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 13V6a2 2 0 00-2-2H6a2 2 0 00-2 2v7m16 0v5a2 2 0 01-2 2H6a2 2 0 01-2-2v-5m16 0h-2.586a1 1 0 00-.707.293l-2.414 2.414a1 1 0 01-.707.293h-3.172a1 1 0 01-.707-.293l-2.414-2.414A1 1 0 006.586 13H4"/>
                                </svg>
                                <p class="mt-4 text-lg">No parcels found</p>
                                <p class="mt-2">Try adjusting your filters or search criteria</p>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <?php if($parcels->hasPages()): ?>
            <div class="bg-white px-4 py-3 border-t border-gray-200 sm:px-6">
                <div class="flex items-center justify-between">
                    <div class="flex-1 flex justify-between sm:hidden">
                        <?php if($parcels->onFirstPage()): ?>
                            <span class="relative inline-flex items-center px-4 py-2 border border-gray-300 text-sm font-medium rounded-md text-gray-400 bg-gray-100 cursor-not-allowed">
                                Previous
                            </span>
                        <?php else: ?>
                            <a href="<?php echo e($parcels->previousPageUrl()); ?>" class="relative inline-flex items-center px-4 py-2 border border-gray-300 text-sm font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50">
                                Previous
                            </a>
                        <?php endif; ?>

                        <?php if($parcels->hasMorePages()): ?>
                            <a href="<?php echo e($parcels->nextPageUrl()); ?>" class="ml-3 relative inline-flex items-center px-4 py-2 border border-gray-300 text-sm font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50">
                                Next
                            </a>
                        <?php else: ?>
                            <span class="ml-3 relative inline-flex items-center px-4 py-2 border border-gray-300 text-sm font-medium rounded-md text-gray-400 bg-gray-100 cursor-not-allowed">
                                Next
                            </span>
                        <?php endif; ?>
                    </div>
                    <div class="hidden sm:flex-1 sm:flex sm:items-center sm:justify-between">
                        <div>
                            <p class="text-sm text-gray-700">
                                Showing
                                <span class="font-medium"><?php echo e($parcels->firstItem() ?? 0); ?></span>
                                to
                                <span class="font-medium"><?php echo e($parcels->lastItem() ?? 0); ?></span>
                                of
                                <span class="font-medium"><?php echo e($parcels->total()); ?></span>
                                results
                            </p>
                        </div>
                        <div>
                            <?php echo e($parcels->links()); ?>

                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>

<script>
    function printLabel(parcelId) {
        window.open(`/admin/parcels/${parcelId}/print-label`, '_blank', 'width=800,height=600');
    }

    function printLabels() {
        const selectedParcels = Alpine.store('selectedParcels');
        if (selectedParcels && selectedParcels.length > 0) {
            window.open(`/admin/parcels/print-labels?ids=${selectedParcels.join(',')}`, '_blank', 'width=800,height=600');
        }
    }

    function exportSelected() {
        const selectedParcels = Alpine.store('selectedParcels');
        if (selectedParcels && selectedParcels.length > 0) {
            window.location.href = `/admin/parcels/export?ids=${selectedParcels.join(',')}`;
        }
    }
</script>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\download\project\final cms\laravel-cms\resources\views/admin/parcels/index.blade.php ENDPATH**/ ?>