<aside id="sidebar" class="w-56 bg-white border-r border-gray-200 min-h-screen fixed left-0 top-16 bottom-0 overflow-y-auto z-20">
    <nav class="py-2">
        <div class="mb-1">
                <h3 class="px-3 py-2 font-semibold text-primary uppercase text-xs tracking-wider">FINANCE & TAX</h3>
                <div class="flex flex-col gap-1">
                    <a href="<?php echo e(\Illuminate\Support\Facades\Route::has('finance.dashboard') ? route('finance.dashboard') : '#'); ?>" 
                       class="flex items-center px-3 py-1.5 text-sm text-gray-700 hover:bg-blue-50 <?php echo e(request()->routeIs('finance.dashboard') ? 'bg-blue-50 text-blue-600 font-bold border-r-4 border-blue-600' : ''); ?>">
                        <i class="fas fa-home w-5 h-5 mr-3"></i>
                        <span>Dashboard</span>
                    </a>

                    <div x-data="{ open: false }">
                        <button @click="open = !open" class="w-full flex items-center justify-between px-3 py-1.5 text-sm text-gray-700 hover:bg-blue-50">
                            <span class="flex items-center">
                                <i class="fas fa-money-bill-wave w-5 h-5 mr-3"></i>
                                <span>Cash & COD Management</span>
                            </span>
                            <i class="fas fa-chevron-down w-3 h-3 transform transition-transform" :class="{ 'rotate-180': open }"></i>
                        </button>
                        <div x-show="open" class="pl-8 mt-1 space-y-1">
                            <a href="#" class="block text-xs text-gray-600 hover:text-blue-600">Daily Cash Collection</a>
                            <a href="#" class="block text-xs text-gray-600 hover:text-blue-600">Deposits to Bank</a>
                            <a href="#" class="block text-xs text-gray-600 hover:text-blue-600">Pending COD Report</a>
                            <a href="#" class="block text-xs text-gray-600 hover:text-blue-600">COD Variance Report</a>
                        </div>
                    </div>
                </div>
            </div>
            <div x-data="{ open: false }">
                        <button @click="open = !open" class="w-full flex items-center justify-between px-3 py-1.5 text-sm text-gray-700 hover:bg-blue-50">
                            <span class="flex items-center">
                                <i class="fas fa-hand-holding-usd w-5 h-5 mr-3"></i>
                                <span>Merchant Settlements</span>
                            </span>
                            <i class="fas fa-chevron-down w-3 h-3 transform transition-transform" :class="{ 'rotate-180': open }"></i>
                        </button>
                        <div x-show="open" class="pl-8 mt-1 space-y-1">
                            <a href="<?php echo e(\Illuminate\Support\Facades\Route::has('finance.settlements.invoices.index') ? route('finance.settlements.invoices.index') : '#'); ?>" class="block text-xs text-gray-600 hover:text-blue-600">Invoices</a>
                            <a href="<?php echo e(\Illuminate\Support\Facades\Route::has('finance.settlements.payments.index') ? route('finance.settlements.payments.index') : '#'); ?>" class="block text-xs text-gray-600 hover:text-blue-600">Payments to Merchants</a>
                            <a href="<?php echo e(\Illuminate\Support\Facades\Route::has('finance.settlements.deductions.index') ? route('finance.settlements.deductions.index') : '#'); ?>" class="block text-xs text-gray-600 hover:text-blue-600">Deductions</a>
                            <a href="<?php echo e(\Illuminate\Support\Facades\Route::has('finance.settlements.pending-report') ? route('finance.settlements.pending-report') : '#'); ?>" class="block text-xs text-gray-600 hover:text-blue-600">Pending Settlement Report</a>
                            <a href="<?php echo e(\Illuminate\Support\Facades\Route::has('finance.settlements.disputes.index') ? route('finance.settlements.disputes.index') : '#'); ?>" class="block text-xs text-gray-600 hover:text-blue-600">Dispute Management</a>
                        </div>
                    </div>
            <div x-data="{ open: false }">
                        <button @click="open = !open" class="w-full flex items-center justify-between px-3 py-1.5 text-sm text-gray-700 hover:bg-blue-50">
                            <span class="flex items-center">
                                <i class="fas fa-book w-5 h-5 mr-3"></i>
                                <span>Company Accounting</span>
                            </span>
                            <i class="fas fa-chevron-down w-3 h-3 transform transition-transform" :class="{ 'rotate-180': open }"></i>
                        </button>
                        <div x-show="open" class="pl-8 mt-1 space-y-1">
                            <a href="#" class="block text-xs text-gray-600 hover:text-blue-600">Chart of Accounts</a>
                            <a href="#" class="block text-xs text-gray-600 hover:text-blue-600">Journal Entries</a>
                            <a href="#" class="block text-xs text-gray-600 hover:text-blue-600">Ledger View</a>
            <a href="<?php echo e(\Illuminate\Support\Facades\Route::has('finance.accounting.trial-balance') ? route('finance.accounting.trial-balance') : '#'); ?>" class="block text-xs text-gray-600 hover:text-blue-600">Trial Balance</a>
                            <a href="#" class="block text-xs text-gray-600 hover:text-blue-600">Balance Sheet</a>
                            <a href="#" class="block text-xs text-gray-600 hover:text-blue-600">Profit & Loss Statement</a>
                        </div>
                    </div>

            <div x-data="{ open: false }">
                        <button @click="open = !open" class="w-full flex items-center justify-between px-3 py-1.5 text-sm text-gray-700 hover:bg-blue-50">
                            <span class="flex items-center">
                                <i class="fas fa-receipt w-5 h-5 mr-3"></i>
                                <span>Expenses & Payments</span>
                            </span>
                            <i class="fas fa-chevron-down w-3 h-3 transform transition-transform" :class="{ 'rotate-180': open }"></i>
                        </button>
                        <div x-show="open" class="pl-8 mt-1 space-y-1">
                            <a href="#" class="block text-xs text-gray-600 hover:text-blue-600">Company Expenses</a>
                            <a href="#" class="block text-xs text-gray-600 hover:text-blue-600">Branch Level Expenses</a>
                            <a href="#" class="block text-xs text-gray-600 hover:text-blue-600">Vendor Payments</a>
                            <a href="#" class="block text-xs text-gray-600 hover:text-blue-600">Expense Approval Flow</a>
                            <a href="#" class="block text-xs text-gray-600 hover:text-blue-600">Recurring Expenses</a>
                        </div>
                    </div>

            <div x-data="{ open: false }">
                        <button @click="open = !open" class="w-full flex items-center justify-between px-3 py-1.5 text-sm text-gray-700 hover:bg-blue-50">
                            <span class="flex items-center">
                                <i class="fas fa-wallet w-5 h-5 mr-3"></i>
                                <span>Payroll & Salaries</span>
                            </span>
                            <i class="fas fa-chevron-down w-3 h-3 transform transition-transform" :class="{ 'rotate-180': open }"></i>
                        </button>
                        <div x-show="open" class="pl-8 mt-1 space-y-1">
                            <a href="<?php echo e(\Illuminate\Support\Facades\Route::has('finance.payroll.employee-master') ? route('finance.payroll.employee-master') : '#'); ?>" class="block text-xs text-gray-600 hover:text-blue-600">Employee Master Data</a>
                            <a href="<?php echo e(\Illuminate\Support\Facades\Route::has('finance.payroll.attendance') ? route('finance.payroll.attendance') : '#'); ?>" class="block text-xs text-gray-600 hover:text-blue-600">Attendance & Overtime</a>
                            <a href="<?php echo e(\Illuminate\Support\Facades\Route::has('finance.payroll.payroll-run') ? route('finance.payroll.payroll-run') : '#'); ?>" class="block text-xs text-gray-600 hover:text-blue-600">Payroll Run</a>
                            <a href="<?php echo e(\Illuminate\Support\Facades\Route::has('finance.payroll.tax-deductions') ? route('finance.payroll.tax-deductions') : '#'); ?>" class="block text-xs text-gray-600 hover:text-blue-600">Tax Deductions</a>
                            <a href="<?php echo e(\Illuminate\Support\Facades\Route::has('finance.payroll.salary-slips') ? route('finance.payroll.salary-slips') : '#'); ?>" class="block text-xs text-gray-600 hover:text-blue-600">Salary Slips</a>
                            <a href="<?php echo e(\Illuminate\Support\Facades\Route::has('finance.payroll.bonus-incentives') ? route('finance.payroll.bonus-incentives') : '#'); ?>" class="block text-xs text-gray-600 hover:text-blue-600">Bonus & Incentives</a>
                        </div>
                    </div>

            <div x-data="{ open: false }">
                        <button @click="open = !open" class="w-full flex items-center justify-between px-3 py-1.5 text-sm text-gray-700 hover:bg-blue-50">
                            <span class="flex items-center">
                                <i class="fas fa-calculator w-5 h-5 mr-3"></i>
                                <span>Taxation & Compliance</span>
                            </span>
                            <i class="fas fa-chevron-down w-3 h-3 transform transition-transform" :class="{ 'rotate-180': open }"></i>
                        </button>
                        <div x-show="open" class="pl-8 mt-1 space-y-1">
                            <a href="#" class="block text-xs text-gray-600 hover:text-blue-600">GST Calculation</a>
                            <a href="#" class="block text-xs text-gray-600 hover:text-blue-600">Income Tax Withholding</a>
                            <a href="#" class="block text-xs text-gray-600 hover:text-blue-600">Tax Filings</a>
                            <a href="#" class="block text-xs text-gray-600 hover:text-blue-600">e-Filing Integration</a>
                            <a href="#" class="block text-xs text-gray-600 hover:text-blue-600">Tax Deduction Reports</a>
                            <a href="#" class="block text-xs text-gray-600 hover:text-blue-600">Tax Calendar Alerts</a>
                        </div>
                    </div>

            <div x-data="{ open: false }">
                        <button @click="open = !open" class="w-full flex items-center justify-between px-3 py-1.5 text-sm text-gray-700 hover:bg-blue-50">
                            <span class="flex items-center">
                                <i class="fas fa-landmark w-5 h-5 mr-3"></i>
                                <span>Banking & Reconciliation</span>
                            </span>
                            <i class="fas fa-chevron-down w-3 h-3 transition-transform" :class="{ 'rotate-180': open }"></i>
                        </button>
                        <div x-show="open" class="pl-8 mt-1 space-y-1">
                            <a href="#" class="block text-xs text-gray-600 hover:text-blue-600">Bank Accounts Linked</a>
                            <a href="#" class="block text-xs text-gray-600 hover:text-blue-600">Bank Reconciliation</a>
                            <a href="#" class="block text-xs text-gray-600 hover:text-blue-600">Cheque Management</a>
                            <a href="#" class="block text-xs text-gray-600 hover:text-blue-600">Discrepancy Alerts</a>
                        </div>
                    </div>

            <div x-data="{ open: false }">
                        <button @click="open = !open" class="w-full flex items-center justify-between px-3 py-1.5 text-sm text-gray-700 hover:bg-blue-50">
                            <span class="flex items-center">
                                <i class="fas fa-file-signature w-5 h-5 mr-3"></i>
                                <span>Vouchers & Manual Entry</span>
                            </span>
                            <i class="fas fa-chevron-down w-3 h-3 transition-transform" :class="{ 'rotate-180': open }"></i>
                        </button>
                        <div x-show="open" class="pl-8 mt-1 space-y-1">
                            <a href="#" class="block text-xs text-gray-600 hover:text-blue-600">Cash Payment Voucher</a>
                            <a href="#" class="block text-xs text-gray-600 hover:text-blue-600">Bank Payment Voucher</a>
                            <a href="#" class="block text-xs text-gray-600 hover:text-blue-600">Cash Receipt Voucher</a>
                            <a href="#" class="block text-xs text-gray-600 hover:text-blue-600">Bank Receipt Voucher</a>
                            <a href="#" class="block text-xs text-gray-600 hover:text-blue-600">Journal Voucher</a>
                            <a href="#" class="block text-xs text-gray-600 hover:text-blue-600">Contra Voucher</a>
                        </div>
                    </div>

            <div x-data="{ open: false }">
                        <button @click="open = !open" class="w-full flex items-center justify-between px-3 py-1.5 text-sm text-gray-700 hover:bg-blue-50">
                            <span class="flex items-center">
                                <i class="fas fa-shield-check w-5 h-5 mr-3"></i>
                                <span>Audit & Controls</span>
                            </span>
                            <i class="fas fa-chevron-down w-3 h-3 transition-transform" :class="{ 'rotate-180': open }"></i>
                        </button>
                        <div x-show="open" class="pl-8 mt-1 space-y-1">
                            <a href="#" class="block text-xs text-gray-600 hover:text-blue-600">Role Based Access</a>
                            <a href="#" class="block text-xs text-gray-600 hover:text-blue-600">Approval Flow</a>
                            <a href="#" class="block text-xs text-gray-600 hover:text-blue-600">Audit Logs</a>
                            <a href="#" class="block text-xs text-gray-600 hover:text-blue-600">System Alerts</a>
                        </div>
                    </div>

            <div x-data="{ open: false }">
                        <button @click="open = !open" class="w-full flex items-center justify-between px-3 py-1.5 text-sm text-gray-700 hover:bg-blue-50">
                            <span class="flex items-center">
                                <i class="fas fa-chart-line w-5 h-5 mr-3"></i>
                                <span>Reports & Analytics</span>
                            </span>
                            <i class="fas fa-chevron-down w-3 h-3 transition-transform" :class="{ 'rotate-180': open }"></i>
                        </button>
                        <div x-show="open" class="pl-8 mt-1 space-y-1">
                            <a href="#" class="block text-xs text-gray-600 hover:text-blue-600">Daily COD Report</a>
                            <a href="#" class="block text-xs text-gray-600 hover:text-blue-600">Merchant Settlement</a>
                            <a href="#" class="block text-xs text-gray-600 hover:text-blue-600">Bank Reconciliation</a>
                            <a href="#" class="block text-xs text-gray-600 hover:text-blue-600">Daily Cash Flow Report</a>
                            <a href="#" class="block text-xs text-gray-600 hover:text-blue-600">COD vs Deposit Report</a>
                            <a href="#" class="block text-xs text-gray-600 hover:text-blue-600">Settlement Aging Report</a>
                            <a href="#" class="block text-xs text-gray-600 hover:text-blue-600">Expense vs Budget Report</a>
                            <a href="#" class="block text-xs text-gray-600 hover:text-blue-600">Payroll Cost Analysis</a>
                            <a href="#" class="block text-xs text-gray-600 hover:text-blue-600">Branch Profitability</a>
                            <a href="#" class="block text-xs text-gray-600 hover:text-blue-600">Tax Reports</a>
                            <a href="#" class="block text-xs text-gray-600 hover:text-blue-600">Financial Statements</a>
                        </div>
                    </div>
        </div>
    </nav>
</aside>
<?php /**PATH D:\download\project\final cms\laravel-cms\resources\views/partials/finance-sidebar.blade.php ENDPATH**/ ?>