

<?php $__env->startSection('title', 'Packaging Logs'); ?>

<?php $__env->startSection('content'); ?>
<div class="space-y-8">
    <div class="flex items-center justify-between">
        <h1 class="text-2xl font-semibold">Packaging Logs</h1>
        <a href="<?php echo e(route('seller.packaging.create')); ?>" class="bg-blue-600 text-white px-4 py-2 rounded-md font-semibold">
            <i class="fas fa-plus-circle mr-2"></i>
            Add New
        </a>
    </div>
    <div class="bg-white rounded-lg shadow-md">
        <div class="p-4 border-b">
            <div class="flex flex-wrap items-center justify-between gap-4">
                <div class="flex items-center gap-2 border-b flex-wrap">
                    <button class="py-2 px-3 border-b-2 border-blue-500 text-blue-600 text-xs h-8">All (0)</button>
                    <button class="py-2 px-3 border-b-2 border-transparent text-gray-500 hover:text-gray-700 text-xs h-8">New (0)</button>
                    <button class="py-2 px-3 border-b-2 border-transparent text-gray-500 hover:text-gray-700 text-xs h-8">Approved (0)</button>
                    <button class="py-2 px-3 border-b-2 border-transparent text-gray-500 hover:text-gray-700 text-xs h-8">Un-Assigned By Me (0)</button>
                </div>
                <div class="flex items-center gap-2">
                    <button class="bg-gray-200 text-gray-700 p-2 rounded-md"><i class="fas fa-sync-alt"></i></button>
                    <button class="bg-gray-200 text-gray-700 p-2 rounded-md"><i class="fas fa-layer-group"></i></button>
                    <button class="bg-gray-200 text-gray-700 p-2 rounded-md"><i class="fas fa-download"></i></button>
                    <button class="bg-gray-200 text-gray-700 p-2 rounded-md"><i class="fas fa-cog"></i></button>
                </div>
            </div>
        </div>
        <div class="p-6 space-y-6">
            <div class="p-4 border rounded-lg bg-gray-50">
                <p class="text-sm font-semibold mb-4 text-gray-500">ADVANCED SEARCH</p>
                <form action="#" method="GET" class="grid grid-cols-1 md:grid-cols-3 lg:grid-cols-4 gap-4 items-end">
                    <div class="md:col-span-2">
                        <label class="text-xs text-gray-500">Search by</label>
                        <div class="flex">
                            <input type="text" placeholder="Search..." class="w-full border-gray-300 rounded-l-md shadow-sm">
                            <button class="bg-gray-200 text-gray-700 px-4 py-2 rounded-r-md font-semibold">PACKAGE #</button>
                        </div>
                    </div>
                    <div>
                        <label class="text-xs text-gray-500">FROM</label>
                        <input type="date" class="w-full border-gray-300 rounded-md shadow-sm">
                    </div>
                    <div>
                        <label class="text-xs text-gray-500">TO</label>
                        <input type="date" class="w-full border-gray-300 rounded-md shadow-sm">
                    </div>
                    <div class="flex items-end gap-2 col-start-1">
                        <button type="submit" class="bg-blue-600 text-white px-4 py-2 rounded-md font-semibold">Search</button>
                        <button type="button" class="bg-gray-200 text-gray-700 px-4 py-2 rounded-md font-semibold">Clear Filter</button>
                    </div>
                </form>
            </div>
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead>
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Package #</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Price</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Merchant Name</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Address</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">City</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Package Date</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Description</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        <tr>
                            <td colspan="8" class="text-center py-10 text-sm text-gray-500">No packaging logs found.</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.seller', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\download\project\final cms\laravel-cms\resources\views/seller/packaging/index.blade.php ENDPATH**/ ?>